<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


if (
    isset($_POST['action']) and
    $_POST['action'] == 'export_account'
) {

    if (!defined('SITE_ROOT')) {
        include_once '../../../netthai_configs.php';
        require 'path.php';
    }


    if (!isset($pdomodel)) {
        $pdomodel = new PDOModel(); //create object of the PDOModel class
        $pdomodel->connect($strHost, $strUser, $strPassword, $strDB); //connect to database
    }

    $data = $pdomodel->executeQuery(
        "SELECT 
      -- @rownum := @rownum + 1 as 'ลำดับ',      
      
    member_firstname,
    member_lastname,
      member_email as 'E-Mail', 
      IF(member_career = 'Other', concat(member_career,' | ',member_career_other), member_career) as member_career,
      member_hospital,
      member_noid,
      @num_street_lines := 1 + LENGTH(member_task) - LENGTH(REPLACE(member_task, '|', '')),
    SUBSTRING_INDEX(member_task, '|', 1) AS street1,
    IF(@num_street_lines > 1, SUBSTRING_INDEX(SUBSTRING_INDEX(member_task, '|', 2), '|', -1), '') AS street2,
    IF(@num_street_lines > 2, SUBSTRING_INDEX(SUBSTRING_INDEX(member_task, '|', 3), '|', -1), '') AS street3,

      member_register,
      member_modify
      -- FROM (select @rownum := 0) r,spmember
      FROM spmember
      ORDER BY member_register DESC;"
    );

    $filename = $project_name . "-" . $_POST['action'] . '-' . date("d-m-Y");

    // Initialize
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Initialize
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Style
    $sheet->getStyle('A1:L1')->applyFromArray(headerStyle());
    foreach (range('A', 'L') as $columnID) {
        $sheet->getColumnDimension($columnID)
            ->setAutoSize(true);
    }
    // Header & Data body
    $headerArray = [
        'First name',
        'Last name',
        'Email address',
        'Specialty',
        'Hospital',
        'ใบประกอบวิชาชีพ',
        'จำนวนงานที่สมัคร',
        'งานที่ 1',
        'งานที่ 2',
        'งานที่ 3',
        'Registration',
        'Update Lasted'
    ];

    $sheet->fromArray($headerArray, null, 'A1');
    $sheet->fromArray($data, null, 'A2');
    $writer = new Xlsx($spreadsheet);

    // Header script
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    exit();
}


function headerStyle()
{
    return $style = [
        'font' => [
            'bold' => true,
        ],
        'alignment' => [
            // 'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
        ],
        'borders' => [
            'top' => [
                // 'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            ],
        ],
        'fill' => [
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'startColor' => [
                'argb' => 'CECECE',
            ]
        ],
    ];
}
