<style>
.dialogQuickgenUser {
    text-align : left;
}
</style>
  
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <section class="content-header">
          <div class="container-fluid">
              <div class="row mb-2">
                  <div class="col-sm-6">
                      <h1>Account Management</h1>
                  </div>
                  <div class="col-sm-6">
                      <ol class="breadcrumb float-sm-right">
                          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                          <li class="breadcrumb-item active">Account Management</li>
                      </ol>
                  </div>
              </div>
          </div><!-- /.container-fluid -->
      </section>

      <!-- Main content -->
      <section class="content">
          <div class="row">
              <div class="col-12">



                  <!-- message state -->
                  <?php include(__DIR__."../../message.php"); ?>
                  <?php require_once(__DIR__.'../../controller/controller_getmember.php'); ?>



                  <div class="card">
                      <div class="card-header">



                          <!-- controller/controller_deletememberall.php -->
                          <?php //encryptIt("10"); ?>
                          <?php //echo decryptIt("Z66e5tE8DE+s+pP+/3eVwo9LaW8RfjpVZ2qRJEwe3eE="); ?>

                          <!-- swalConfirmDeleteAll -->


                          
                          <!-- <div class="form-group"> -->
                              
                              <!-- <button onclick="newUser()" class="btn btn-info"><i class="fas fa-user"></i>
                                  เพิ่มผู้ใช้</button> -->

                          <!-- </div> -->
                          <button type="button" onclick="deleteAllUser()" class="btn btn-danger"><i
                                      class="fas fa-trash"></i>
                                  ลบทั้งหมด</button>


                          <!-- <button onclick="initTable(true)" class="btn btn-success"><i class="fas fa-user"></i>
                              บัญชีผู้ใช้ ที่มีสิทธิ์รับชม</button> -->

                          <!-- <button onclick="initTable(false)" class="btn btn-warning"> <i class="fas fa-user"></i>
                              บัญชีผู้ใช้ ที่ไม่มีสิทธิ์รับชม</button> -->








                          <div class="card-tools">
                              <form method='POST' action='ajax/export_account_file.php'>
                                  <input type='hidden' name='action' value='export_account'>
                                  <button type='submit' class='btn btn-info' data-toggle="tooltip" title="Export files">
                                      <i class="fas fa-file-export"></i>
                                      </a>
                              </form>
                          </div>


                      </div>
                      <!-- /.card-header -->
                      <div class="card-body">





                          <div id="toolbar">
                              <button id="remove" class="btn btn-danger" disabled>
                                  <i class="glyphicon glyphicon-remove"></i> ลบข้อมูลที่เลือก
                              </button>
                          </div>
                          <table id="table" data-toolbar="#toolbar" data-id-field="member_id" data-search="true"
                              data-show-refresh="true" data-show-columns="true" data-show-columns-toggle-all="true"
                              data-show-export="true" data-click-to-select="true" data-pagination="true"
                              data-page-list="[10, 25, 50, 100, all]" data-side-pagination="server"
                              data-response-handler="responseHandler">
                          </table>



                      </div>
                      <!-- /.card-body -->
                  </div>
                  <!-- /.card -->
              </div>
              <!-- /.col -->
          </div>
          <!-- /.row -->
      </section>
      <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->








  <script>
var $table = $('#table')
var $remove = $('#remove')
var selections = []

function getIdSelections() {
    return $.map($table.bootstrapTable('getSelections'), function(row) {
        return row.member_id
    })
}


function responseHandler(res) {
    $.each(res.rows, function(i, row) {
        row.state = $.inArray(row.member_id, selections) !== -1
    })
    return res
}



function initTable(status) {
    if (status === true || status === false)
        var urlSoruce = `ajax/getMember.php?status=${status}`;
    else
        var urlSoruce = `ajax/getMember.php`;

    console.log(urlSoruce);

    $table.bootstrapTable('destroy').bootstrapTable({
        url: urlSoruce,
        height: 500,
        columns: [{
                field: 'state',
                checkbox: true,
                align: 'center',
                valign: 'middle'
            },
            {
                field: 'member_firstname',
                title: 'First name',
                sortable: false,
                align: 'center'
            },
            {
                field: 'member_lastname',
                title: 'Last name',
                sortable: false,
                align: 'center'
            },
            {
                field: 'member_email',
                title: 'Email address',
                sortable: false,
                align: 'center'
            },
            {
                field: 'member_career',
                title: 'Specialty',
                sortable: false,
                align: 'center'
            },
            {
                field: 'member_hospital',
                title: 'Hospital',
                sortable: false,
                align: 'center'
            },
            {
                field: 'member_province',
                title: 'Province',
                sortable: false,
                align: 'center'
            },
            {
                field: 'operate',
                title: 'Action',
                align: 'center',
                clickToSelect: false,
                events: window.operateEvents,
                formatter: operateFormatter
            }
        ]
    })
    $table.on('check.bs.table uncheck.bs.table ' +
        'check-all.bs.table uncheck-all.bs.table',
        function() {
            $remove.prop('disabled', !$table.bootstrapTable('getSelections').length)

            // save your data, here just save the current page
            selections = getIdSelections()
            // push or splice the selections if you want to save all data selections
        })
    $table.on('all.bs.table', function(e, name, args) {
        console.log(name, args)
    })
    $remove.click(function() {
        var ids = getIdSelections()
        console.log(ids);
        callAjaxDelMember(ids);
        $table.bootstrapTable('remove', {
            field: 'member_id',
            values: ids
        })
        $remove.prop('disabled', true)
    })

}

function calcTaskFormatter(value, row, index){

    let tasks = value.split("|");
    // console.log(tasks);
    return `<span class="badge badge-warning p-2" style="font-size:0.8rem;">${tasks}</span>`
}

function operateFormatter(value, row, index) {
    return [
        '<a class="like btn btn-info" href="javascript:void(0)" title="Edit">',
        '<i class="fa fa-edit"></i>',
        '</a>  ',
        '<a class="remove btn btn-danger" href="javascript:void(0)" title="Remove">',
        '<i class="fa fa-trash"></i>',
        '</a>'
    ].join('');
}

function registerStateFormatter(value, row, index) {
    if (value == '1') {
        return [
            '<span class="badge badge-success" style="font-size:0.8rem;">ลงทะเบียนล่วงหน้า</span>',
        ].join('');
    } else {

        return [
            '<span class="badge badge-info" style="font-size:0.8rem;">ปกติ</span>',
        ].join('');
    }
}

function memberStatusFormatter(value, row, index) {

    if (value == '1') {
        return [
            '<span class="badge badge-success p-2" style="font-size:0.8rem;">ปกติ</span>',
        ].join('');
    } else {

        return [
            '<span class="badge badge-warning p-2" style="font-size:0.8rem;">ไม่มีสิทธิ์รับชม</span>',
        ].join('');
    }
}


window.operateEvents = {
    'click .like': function(e, value, row, index) {
        // alert('You click like action, row: ' + JSON.stringify(row))
        LoadDialogConfirm(row);
    },
    'click .remove': function(e, value, row, index) {
        callAjaxDelMember(row.member_id);
        $table.bootstrapTable('remove', {
            field: 'member_id',
            values: [row.member_id]
        })
    }
}

$(function() {
    // $table.bootstrapTable();
    initTable()

    $("input[data-bootstrap-switch]").each(function() {
        $(this).bootstrapSwitch('state', $(this).prop('checked'));
    });
})


async function LoadDialogConfirm(row) {
    console.log(JSON.stringify(row));

    let tasks = []

    if(row.member_task) tasks = row.member_task.split("|");
    
    const {
        value: formValues
    } = await Swal.fire({
        title: 'แก้ไขงาน',
        customClass:{
            content: 'dialogQuickgenUser'
        },
        html: `           
        <label style="font-size:1rem; color:grey">*หากต้องการลบงาน ให้กำหนดเป็นค่า "ว่าง" แล้วบันทึก</label>
        <input type="text" class="form-control" hidden id="member_id" value="${row.member_id}">

                  <div class="form-group">
                    <label for="exampleInputEmail1">งานที่เข้าร่วม 1</label>
                    <input type="text" class="form-control" id="task1" value="${tasks[0] ? tasks[0] : ''}">
                  </div>

                  <div class="form-group">
                    <label for="exampleInputEmail1">งานที่เข้าร่วม 2</label>
                    <input type="text" class="form-control" id="task2" value="${tasks[1] ? tasks[1] : ''}">
                  </div>

                <hr/>
                  <div class="form-group">
                  <label for="">สถานะรับชม</label>
                  <br/>
                  <label class="radio-inline">
                    <input type="radio" name="member_status" value="1" ${row.member_status == '1' ? 'checked' : ''}> ปกติ
                  </label>
                <span style="margin-right:2rem"></span>
                  <label class="radio-inline">
                    <input type="radio" name="member_status" value="0" ${row.member_status == '0' ? 'checked' : ''}> ไม่มีสิทธิ์รับชม
                  </label>
                      </div>
            `,
        showCancelButton: true,
        focusConfirm: false,
        preConfirm: () => {
            return {
                'member_id': $('#member_id').val(),
                'task1': $('#task1').val(),
                'task2': $('#task2').val(),
                'member_status': $('input[name="member_status"]:checked').val()
            }
        }
    })

    if (formValues) {
        // Swal.fire(JSON.stringify(formValues))
        // console.log(JSON.stringify(formValues));
        const myObj = JSON.stringify(formValues);
        const myJson = JSON.parse(myObj);
        // console.log(myObj);
        // console.log(JSON.parse(myObj));
        // console.log(myJson.member_id);
        // var myJson = JSON.parse(formValues)
        // console.log(myJson);
        callAjaxEditMember(myJson);
        console.log(myJson);
    }


}

function callAjaxEditMember(data) {
    
    $.ajax({
        url: 'ajax/updateMember.php',
        type: 'POST',
        data: {
            'action': 'updateMember',
            'member_id': data.member_id,
            'task1' : data.task1,
            'task2' : data.task2,
            'member_status': data.member_status
        },
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(res) {
            const data = JSON.parse(res);
            if (data.msg == 'success') {
                Swal.fire({
                    icon: 'success',
                    title: 'ได้ทำรายการเรียบร้อยแล้ว',
                    showConfirmButton: false,
                    timer: 1500
                })
                // initTable()
                $table.bootstrapTable('refresh')

            } else if (data.msg == "notchange") {
                Swal.fire({
                    icon: 'warning',
                    title: 'ไม่พบข้อมูลการเปลี่ยนแปลง',
                    showConfirmButton: false,
                    timer: 1500
                })
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'พบข้อผิดพลาดบางประการ กรุณาลองใหม่ภายหลัง',
                    showConfirmButton: false,
                    timer: 1500
                })
            }

        },
        error: function() {
            alert("error");
        }
    });
}

function callAjaxDelMember(ids) {
    $.ajax({
        url: 'ajax/deleteMember.php',
        type: 'POST',
        data: {
            'action': 'delMember',
            'ids': ids
        },
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(res) {
            console.log(res);
            Swal.fire({
                icon: 'success',
                title: 'ได้ทำรายการเรียบร้อยแล้ว',
                showConfirmButton: false,
                timer: 1500
            })


            // alert(response.status);
            // alert(res);
        },
        error: function() {
            alert("error");
        }
    });
}

$('.swalConfirmDeleteAll').click(function() {
    Swal.fire({
        title: 'คำเตือน',
        text: "ต้องการลบข้อมูลบัญชีผู้ใช้งานทั้งหมดหรือไม่?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'ปิด',
        confirmButtonText: 'ใช่, ลบทั้งหมด'
    }).then((result) => {
        if (result.value) {
            window.location.href = "controller/controller_deletememberall.php";
        }
    })
});

function deleteAllUser() {
    Swal.fire({
        title: 'คำเตือน',
        text: 'ต้องการลบข้อมูลบัญชีผู้ใช้งานทั้งหมดหรือไม่',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'ปิด',
        confirmButtonText: 'ใช่, ลบทั้งหมด',
        showLoaderOnConfirm: true,
        preConfirm: () => {
            return fetch('controller/controller_deletememberall.php')
                .then(response => {
                    if (!response.ok) {
                        throw new Error(response.statusText)
                    }
                    return response.json()
                })
                .catch(error => {
                    Swal.showValidationMessage(
                        `Request failed: ${error}`
                    )
                })
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.value) {
            Swal.fire('ลบข้อมูลเรียบร้อยแล้ว', '', 'success')
            $table.bootstrapTable('refresh')
        }
    })
}

async function newUser() {
    const {
        value: email
    } = await Swal.queue([{
        title: 'Input email address',
        input: 'email',
        confirmButtonText: 'บันทึก',
        cancelButtonText: 'ปิด',
        showCancelButton: true,
        inputPlaceholder: 'Enter your email address',
        showLoaderOnConfirm: true,
        preConfirm: (email) => {
            return fetch(`ajax/addMember.php?email=${email}`)
                .then(response => {
                    if (!response.ok) {
                        throw new Error(response.statusText)
                    }
                    return response.json()
                })
                .then(data => {
                    if (data.status == "success") {
                        Swal.fire('บันทึกข้อมูลเรียบแล้ว', '', 'success')
                        $table.bootstrapTable('refresh')

                    } else if (data.status == "email_already") {
                        Swal.fire('ล้มเหลว', 'มีข้อมูล Email นี้อยู่ในฐานข้อมูลแล้ว', 'warning')
                    } else {
                        Swal.fire('ล้มเหลว',
                            'เกิดข้อผิดพลาดในการเชื่อมต่อกับเซิฟเวอร์ หรือ อินเทอร์เน็ทของท่านไม่เสถียร',
                            'error')
                    }
                })
                .catch(() => {
                    Swal.insertQueueStep({
                        icon: 'error',
                        title: 'เกิดข้อผิดพลาดในการเชื่อมต่อกับเซิฟเวอร์ หรือ อินเทอร์เน็ทของท่านไม่เสถียร'
                    })
                })
        },
        allowOutsideClick: () => !Swal.isLoading()
    }])
}
  </script>