<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Video & Live Stream Management</h1>
                </div>

                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active">Live Stream</li>
                    </ol>
                </div>
            </div>
            <?php include(__DIR__."../../message.php"); ?>
            <?php require_once(__DIR__.'../../controller/controller_getfiles.php'); ?>
            <?php require_once(__DIR__.'../../controller/controller_getstream.php'); ?>
            <?php //require_once(__DIR__.'../../controller/getLandingPage.php'); ?>

        </div><!-- /.container-fluid -->
    </section>

    <!-- form start -->
    <!-- controller/controller_streamupdate.php -->
    <form role="form" action="" method="POST">
        <input type="hidden" name="action" value="stream">

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">



                    <!-- left column -->
                    <div class="col-md-6">
                        <!-- general form elements -->
                        <div class="card card-defualt">
                            <div class="card-body">
                                <!-- BODY -->
                                <div class="form-group">
                                    <label>Video Files:</label>
                                    <select class="form-control select2" style="width: 100%;" name="selectBox"
                                        id="selectBox">
                                        <option selected="selected" value="">Choose video file</option>
                                        <?php foreach ($videoLists as $file ): $file = str_replace($directory.'/','',$file)?>
                                        <?php if (str_replace($base_url.$pathVideo.'/','',$arr[0]['stream_flash2']) == $file): ?>
                                        <option value='<?= $file ?>' selected>
                                            <?= $file ?></option>
                                        <?php else: ?>
                                        <option value='<?= $file ?>'><?= $file ?>
                                        </option>
                                        <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Live Channel (HLS .m3u8)</label></label>
                                    <input class="form-control"
                                        placeholder="https://ip-server:1935/livech/live/playlist.m3u8" name="flash1"
                                        id="flash1" value='<?php echo $arr[0]['stream_flash1'];?>'>

                                </div>

                                <!-- <div class="form-group">
                                    <label>Task:</label>
                                    <select class="form-control select2" style="width: 100%;" name="selectBox2"
                                        id="selectBox2">
                                        <option selected="selected" value="">Choose video file</option>
                                        <?php foreach ($resultLandingPages as $task ): ?>
                                        <?php if ($task['page_id'] == $arr[0]['page_id']) : ?>
                                        <option value='<?= $task['page_id'] ?>' selected>
                                            <?= $task['page_name'] ?></option>
                                        <?php else: ?>
                                        <option value='<?= $task['page_id'] ?>'><?= $task['page_name'] ?>
                                        </option>
                                        <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </div> -->


                                <div class="form-group">
                                    <label>Player Type</label>
                                    <div class="radio">
                                        <label>
                                            <input type="radio" name="showType" id="" value="stream"
                                                <?=$arr[0]['show_type'] == 'stream' ? 'checked':''?>> 
                                            Streaming (live stream source)
                                        </label>
                                    </div>

                                    <div class="radio">
                                        <label>
                                            <input type="radio" name="showType" id="" value="video"
                                                <?=$arr[0]['show_type'] == 'video' ? 'checked':''?>> Video (mp4 source)
                                        </label>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label>Status</label>
                                    <div class="radio">
                                        <label>
                                            <input type="radio" name="status" id="optionsRadios1" value="1"
                                                <?php   if($arr[0]['stream_status']) echo 'checked'; ?>> Enable
                                        </label>
                                    </div>
                                    <div class="radio">
                                        <label>
                                            <input type="radio" name="status" id="optionsRadios2" value="0"
                                                <?php  if(!$arr[0]['stream_status']) echo 'checked'; ?>> Disable
                                        </label>
                                    </div>
                                </div>

                                <!-- <div class="form-group">
                                    <label>Status Login Button [Main]</label>
                                    <div class="radio">
                                        <label>
                                            <input type="radio" name="login_status" id="optionsRadios1" value="1"
                                                <?php   if($arr[0]['login_status']) echo 'checked'; ?>> Enable
                                        </label>
                                    </div>
                                    <div class="radio">
                                        <label>
                                            <input type="radio" name="login_status" id="optionsRadios2" value="0"
                                                <?php  if(!$arr[0]['login_status']) echo 'checked'; ?>> Disable
                                        </label>
                                    </div>
                                </div> -->


                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <button onclick="save()" type="button" class="btn btn-success"><i
                                        class="fa fa-check fa-fw"></i> Save</button>
                                <button type="button" class="btn btn-warning testVideo"><i class="fas fa-sync-alt"></i>
                                    Test Video</button>
                            </div>
                        </div>
                        <!-- /.card -->

                    </div>
                    <!--/.col (left) -->

                    <!-- right column -->
                    <div class="col-md-6">

                        <div class="card direct-chat direct-chat-warning">
                            <div class="card-header">
                                <h3 class="card-title">Player</h3>

                                <div class="card-tools">
                                    <!-- <span data-toggle="tooltip" title="3 New Messages" class="badge badge-warning">3</span> -->
                                </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">

                                <!-- Element player -->
                                <div id="clappr"></div>


                                <!-- Conversations are loaded here -->
                                <div class="direct-chat-messages">
                                    <div id="BodyQuestion"></div>
                                </div>
                                <!--/.direct-chat-messages-->

                                <!-- /.direct-chat-pane -->
                            </div>
                            <!-- /.card-body -->
                             <div class="card-footer">
                                <form action="" method="post" id="form_chat">
                                    <div class="input-group">
                                        <?php $session_user_id = $adminModel->getSession();?>
                                        <input type="text" name="user_id" id="user_id" hidden
                                            value="<?= $session_user_id[0]['user_id'] ?>" />
                                        <input type="text" name="message" placeholder="Type Message ..."
                                            class="form-control" id="message">
                                        <span class="input-group-append">
                                            <button type="button" class="btn btn-warning"
                                                onclick=addChat()>Send</button>
                                        </span>
                                    </div>
                                </form>
                            </div>
                            <!-- /.card-footer-->
                        </div>


                    </div>
                    <!--/.col (right) -->

                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content -->
</div>
<!-- /.content-wrapper -->
</form>



<!--End Form Validation-->
<!-- ############# -->

<script>
var temp_data_size = 0;

var isMouseOver = false;
$(".direct-chat-messages").mouseover(function() {
    console.log(`mouse over`);
    isMouseOver = true;
});
$(".direct-chat-messages").mouseout(function() {
    console.log(`mouse out`);
    isMouseOver = false;
});

function addChat() {
    var user_id = $('#user_id').val();
    var msg = $('#message').val().trim();


    if (msg != "" && user_id) {
        $.ajax({
            url: 'ajax/addChat.php',
            type: 'post',
            // data: $("#form_chat").serialize(),
            data: {
                'message': msg,
                'user_id': user_id
            },
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            success: function(res) {
                console.log(res);
                loadChats();


                // alert(response.status);
                // alert(res);
            },
            error: function() {
                //alert("error");
            }
        });
        $('#message').val('');
    }

}

function loadChats() {
    $.ajax({
        url: 'ajax/getChat.php',
        method: 'POST',
        dataType: 'json',
        success: function(data) {


            var pathPic = "";
            var body = "";

            $("#BodyQuestion").html('');
            if (data.length == 0) {
                $("#BodyQuestion").html('<span style="font-size:1rem;">ยังไม่มีข้อความสนทนา</span>');
            }
            console.log("data.length: " + data.length);
            console.log("temp_data_size: " + temp_data_size);

            for (var i = 0; i < data.length; i++) {


                if (data[i].user_username != null) {
                    // admin style
                    name = data[i].user_username;
                    pathPic = '../../images/avatar.png';
                    message = '<span style="color:blue;">' + data[i].chat_message + '</span>';
                } else {
                    // member style
                    if (data[i].chat_status == false) {
                        //pending
                        name = data[i].member_name +
                            "<span class='badge badge-warning'>บทสนทนารออนุมัติ</span>";
                    } else {
                        name = data[i].member_name;
                    }
                    //name = data[i].member_firstname + data[i].chat_status;
                    pathPic = (data[i].member_thumbpic) ? '../../uploads/member/' + data[i]
                        .member_thumbpic : '../../images/avatar.png';
                    message = data[i].chat_message;
                }

                date = formatDate2(data[i].chat_created);

                body += '<div class="direct-chat-msg">';
                body += '<div class="direct-chat-infos clearfix">';
                body += '<span class="direct-chat-name float-left">' + name + '</span>';
                body += '<span class="direct-chat-timestamp float-right">' + date + '</span>';
                body += '</div>';
                body += '<img class="direct-chat-img" src="' + pathPic + '" alt="message user image">';
                body += '<div class="direct-chat-text">';
                body += message;
                body += '</div>';
                body += '</div>';

            }

            $("#BodyQuestion").append(body);
            if (!isMouseOver && temp_data_size != data.length) {
                $(".direct-chat-messages").animate({
                    scrollTop: $(".direct-chat-messages").prop("scrollHeight")
                }, 500);
                console.log('scroll working');
            }

            temp_data_size = data.length;

        }
    }).then(function() {
        setTimeout(loadChats, 10000);
    });
}
loadChats();
</script>



<script>
$(document).ready(function() {


    $("#message").on('keyup', function(e) {
        if (e.keyCode === 13) {
            addChat();
        }
    });



    var flash1 = $('input[name=flash1]').val();
    var flash2 = $('input[name=flash2]').val();
    var status = $("input[name='status']:checked").val();
    var login_status = $("input[name='login_status']:checked").val();
    var type = $("input[name=showType]:checked").val();

    var soruce = $("#selectBox option:selected").val();
    // var soruceSplit = soruce.split("|");

    let str_path = '';
    str_path += '<?=$base_url.$pathVideo.'/'?>'
    str_path += soruce;


    if (type == "stream") {
        PlayerClappr(flash1);
    } else if (type == "vimeo") {
        PlayerVimeo(flash2);
    } else {
        PlayerClappr(str_path);
    }

});

$('.radio_type').change(function() {
    type = $("input[name='showType']:checked").val();
    console.log(type);
});

$('#flash1').change(function() {
    source = $('#flash1').val();
});


$(".testLive").click(function() {
    var flash1 = $('input[name=flash1]').val();
    var flash2 = $('input[name=flash2]').val();
    var status = $("input[name='status']:checked").val();
    var type = $("input[name=showType]:checked").val();

    if (type == "stream") {
        PlayerClappr(flash1);
    } else if (type == "vimeo") {
        PlayerVimeo(flash2);
    }
});


$(".testVideo").click(function() {
    // PlayerClappr($('#selected').val());
    // var videofile = $("#selectBox").value.split("|");
    // var soruceSplit = soruce.split("|");
    var flash1 = $('input[name=flash1]').val();
    var soruce = $("#selectBox option:selected").val();
    var type = $("input[name=showType]:checked").val();

    let str_path = '';
    str_path += '<?=$base_url.$pathVideo.'/'?>'
    str_path += soruce;

    console.log(str_path);
    console.log(type);

    if (type == "stream") {
        PlayerClappr(flash1);
    } else if (type == "vimeo") {
        PlayerVimeo(flash2);
    } else {
        PlayerClappr(str_path);
    }

});

function PlayerVimeo(src) {
    console.log('PlayerVimeo :' + src);
    $('#clappr').html('<div id="v" style="padding:56.25% 0 0 0;position:relative;"><iframe src="' + src +
        '" frameborder="0" allow="autoplay; fullscreen" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;"></iframe></div>'
    );
}

function PlayerClappr(src) {
    console.log('PlayerClappr :' + src);
    $('#v').remove();
    var player = new Clappr.Player({
        parentId: "#clappr",
        source: src,
        width: '100%',
        height: '100%',
        mute: true,
        autoPlay: true,
        poster: "",
        plugins: [LevelSelector],
        levelSelectorConfig: {
            title: 'Quality',
            labels: {
                0: "360p",
                1: "160p",
            }
        },
    });
    player.on(Clappr.Events.PLAYER_ERROR, function() {
        // document.getElementById('clappr').innerHTML = '<img src="stopokmd.jpg" />';
    })
    player.on(Clappr.Events.PLAYER_ENDED, function() {
        console.log('Clappr.Events.PLAYBACK_ENDED');
    })

    player.on(Clappr.Events.PLAYER_PLAY, function() {
        console.log("playing!")
    })
}


function save() {
    var soruce = $("#selectBox option:selected").val();
    // var page_id = $("#selectBox2 option:selected").val();

    var flash1 = $('input[name=flash1]').val();
    // var flash2 = $('input[name=flash2]').val();
    var status = $("input[name='status']:checked").val();
    var login_status = $("input[name='login_status']:checked").val();
    

    
    var type = $("input[name=showType]:checked").val();

    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    $.ajax({
        url: 'controller/controller_streamupdate.php',
        type: 'POST',
        dataType: 'JSON',
        data: {
            'video': soruce,
            // 'page_id': page_id,
            'flash1': flash1,
            'status': status,
            'login_status': login_status,
            'show_type' : type,
            'action': 'stream'
        },
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(res) {
            console.log(res);
            switch (res.msg) {
                case "success":
                    Swal.fire(
                        'สำเร็จ',
                        'บันทึกข้อมูลเรียบร้อยแล้ว',
                        'success'
                    )
                    break;
                case "notchange":
                    Swal.fire(
                        'เอ๊ะ..พบปัญหา',
                        'ไม่พบข้อมูลเปลี่ยนแปลง',
                        'warning'
                    )
                    break;

                default:
                    Swal.fire(
                        'เกิดข้อผิดพลาด!',
                        'เกิดข้อผิดพลาดระหว่างการติดต่อกับเซิฟเวอร์!',
                        'error'
                    )
                    break;
            }

            // alert(response.status);
            // alert(res);
        },
        error: function() {
            // alert("error");
        }
    });

}
</script>