<?php
require 'path.php';

header('Content-type:application/json;charset=utf-8');

try {
    if (
        !isset($_FILES['file']['error']) ||
        is_array($_FILES['file']['error'])
    ) {
        throw new RuntimeException('Invalid parameters.');
    }

    switch ($_FILES['file']['error']) {
        case UPLOAD_ERR_OK:
            break;
        case UPLOAD_ERR_NO_FILE:
            throw new RuntimeException('No file sent.');
        case UPLOAD_ERR_INI_SIZE:
        case UPLOAD_ERR_FORM_SIZE:
            throw new RuntimeException('Exceeded filesize limit.');
        default:
            throw new RuntimeException('Unknown errors.');
    }

    // custom file path
    $filepath = sprintf($pathUpload.$pathBackground.'%s_%s', uniqid(), $_FILES['file']['name']);

    if (!move_uploaded_file($_FILES['file']['tmp_name'], $filepath)) {
        throw new RuntimeException('Failed to move uploaded file.');
    } else {
        $files = glob($pathUpload.$pathBackground.'*'); //get all file names
        foreach ($files as $file) {
            if (is_file($file) && ($file != $filepath) )
                unlink($file); //delete file
        }
    }

    $filepath = str_replace($pathUpload.$pathBackground,$base_url.$pathBackground,$filepath);

    $pdomodel->select("bg");
    if($pdomodel->totalRows == 0){
        // store to db.
        $insertPlayerPoster["file_name"] = $_FILES['file']['name']; 
        $insertPlayerPoster["path_url"] = $filepath;
        $insertPlayerPoster["status"] = true; 
        $pdomodel->insert("bg", $insertPlayerPoster);
    }else{
        // update to db.
        $updatePlayerPoster["file_name"] = $_FILES['file']['name']; 
        $updatePlayerPoster["path_url"] = $filepath;
        $pdomodel->where('id', 1);
        $pdomodel->update("bg", $updatePlayerPoster);
    }
    

    // All good, send the response
    echo json_encode([
        'status' => 'ok',
        'path' => $filepath
    ]);
} catch (RuntimeException $e) {
    // Something went wrong, send the err message as JSON
    http_response_code(400);

    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
