<?php
require 'path.php';

header('Content-type:application/json;charset=utf-8');

$page_id = $_POST['id'];


try {
    if (
        !isset($_FILES['file']['error']) ||
        is_array($_FILES['file']['error'])
    ) {
        throw new RuntimeException('Invalid parameters.');
    }

    switch ($_FILES['file']['error']) {
        case UPLOAD_ERR_OK:
            break;
        case UPLOAD_ERR_NO_FILE:
            throw new RuntimeException('No file sent.');
        case UPLOAD_ERR_INI_SIZE:
        case UPLOAD_ERR_FORM_SIZE:
            throw new RuntimeException('Exceeded filesize limit.');
        default:
            throw new RuntimeException('Unknown errors.');
    }

    // custom file path
    $filename = sprintf('%s_%s', uniqid(), $_FILES['file']['name']);

    $filepath = $pathUpload.$pathLanding.$filename;
    
    

    if (!move_uploaded_file($_FILES['file']['tmp_name'], $filepath)) {
        throw new RuntimeException('Failed to move uploaded file.');
    } else {
        $pdomodel->where('page_id', $page_id);
        $results = $pdomodel->select('ui_page');
        $old_top_file = $results[0]['top_file_name'];
        unlink($pathUpload.$pathLanding.$old_top_file);

        // $files = glob($pathUpload.$pathLanding.'*'); //get all file names
        // foreach ($files as $file) {
        //     if (is_file($file) && ($file != $filepath) )
        //         unlink($file); //delete file
        // }
    }

    $filepath = str_replace($pathUpload.$pathLanding,$base_url.$pathLanding,$filepath);

     // update to db.
    //  $updateTopGP["top_file_name"] = $_FILES['file']['name']; 
     $updateTopGP["top_file_name"] = $filename; 
     $updateTopGP["top_path_url"] = $filepath;
     $pdomodel->where('page_id', $page_id);
     $pdomodel->update("ui_page", $updateTopGP);
    

    // All good, send the response
    echo json_encode([
        'status' => 'ok',
        'path' => $filepath
    ]);
} catch (RuntimeException $e) {
    // Something went wrong, send the err message as JSON
    http_response_code(400);

    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
