<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Surveys extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('frontend/Surveys_model');
        $this->load->model('frontend/Questions_model');
        $this->load->model('frontend/Visitors_model');
        $this->form_validation->set_error_delimiters('<div style="font-weight:bold;color:#d9534f;">', '</div>');
        // unset($_SESSION['voted']);
	}

	public function index()
	{
		$data['content'] = 'frontend/surveys/list_view';
		$this->load->view('template/frontend_template', $data);
	}

    function show($survey_id = NULL)
    {   
        # Check Voted 
        // $votedtime = 60*60*24; // second eg.60*60*24 = 1 day
        // if(isset($_SESSION['voted']) && time()-$_SESSION['voted']<$votedtime){
        //     $this->session->set_flashdata('message', 'ท่านเคยโหวตแล้ว');
        //     $this->session->set_flashdata('message_type', 'warning');
        //     redirect('surveys/report/'.$survey_id,'refresh');
        //  }
        
        // $survey_id = decrypt(urldecode($survey_id));
        $data['survey'] = $this->Surveys_model->show($survey_id);
        $data['questions'] = $this->Questions_model->list_render($survey_id);
        
        if(isset($data['survey']['survey_id'])){
            $data['content'] = 'frontend/surveys/show_view'; // view
            $this->load->view('template/frontend_template', $data); // template
        }else{
            redirect('surveys','refresh');
        }
    }

    function answer($survey_id = NULL)
    { 
        if(isset($_POST) && count($_POST) > 0)     
        {   
            # Insert Visitors
            $params = array(
                'survey_id' => $survey_id,
                'visitor_comment' => $this->input->post('comment'),
                'question_id' => $this->input->post('question_id'),
                'created_at' => date('Y-m-d H:i:s')
            );
            $visitor_id = $this->Visitors_model->create_visitor($params);

            # Create Voted 
            // $_SESSION['voted']=time();

            $this->session->set_flashdata('message','Voted');
            $this->session->set_flashdata('message_type','success');
            redirect('surveys/show/'.$survey_id,'refresh');
        }
        else
        {   
            redirect('surveys','refresh');
        } //.if POST
    }


    function report($survey_id = NULL)
    {   
        $data['survey'] = $this->Surveys_model->show($survey_id);
        $data['questions'] = $this->Questions_model->list_render($survey_id);
        $data['countvisitor'] = $this->Visitors_model->list_count($survey_id);
        $data['comments'] = $this->Visitors_model->list_comment($survey_id);
        
        if(isset($data['survey']['survey_id']))
        {
            $this->load->view('frontend/surveys/report_view-chartjs', $data); // template
        }
        else
        {
            redirect('surveys','refresh');
        }
    }

    function json($survey_id = NULL)
    {
        $data['questions'] = $this->Questions_model->list_render($survey_id);

        $data['countvisitor'] = $this->Visitors_model->list_count($survey_id);

        // get technician
        foreach ($data['questions'] as $key => $result)
        {
            $data['answers'][$key] = number_format(($this->Visitors_model->count_score($result['question_id'])*100)/$data['countvisitor'],2);
        }
        
        $this->output->set_content_type('application/json')->set_output(json_encode($data));

    }

}
