// ------ READY TO START SCRIPT ------

window.addEventListener(
  'contextmenu',
  function (e) {
    // do something here...
    e.preventDefault()
  },
  false
)

$(function () {
  $('#end_btn').hide()

  console.log('update state ready.')
  updateState()
  loadPoll()

  var source = $('#source').val()
  var type = $('#type').val()
  var poster_url = $('#poster_url').val()

  console.log('source:' + source)
  console.log(type)

  switch (type) {
    case 'stream':
      PlayerClappr(source, poster_url)
      break
    case 'vimeo':
      PlayerVimeo(source)
      break
    case 'video':
      PlayerClappr(source, poster_url)

    default:
      PlayerClappr(source, poster_url)
      break
  }
})

function loadPoll() {

  console.log('Load Poll Attach Link')

  $.getJSON('ajax/attachpoll.php', function (data) {
    var items = [];
    $.each( data, function( key, val ) {
      items.push( `<div class="col-6 p-1">
      <a href="${val.at_poll_link}" target="_blank"
         class="btn btn-primary btn-block btnMystyle">
         <span style="font-size:1rem;">${val.at_poll_name}</span></a>
  </div>` );
    });
    $('#poll_box').html('')
    $('#poll_box').append(items)
  })

  setTimeout(loadPoll, 5000);
}

function updateState() {
  $.ajax({
    type: 'POST',
    url: 'runtime.php',
    dataType: 'json',
    data: {
      id: $('#memId').val(),
      stats_id: $('#stats_id').val(),
    },
    success: function (data) {
      // console.log(JSON.stringify(data));
      // console.log(data.code);
      if (data.code == '0' || data.code == '2') {
        $(location).attr('href', 'logout.php')
      }
      console.log('update state success.')
    },
    error: function (jqXHR, textStatus, errorThrown) {
      console.log(textStatus, errorThrown)
      console.log('update state error.')
    },
  }).then(function () {
    console.log('update state queue.')
    setTimeout(updateState, 30000)
  })
}

function LoadDialog() {
  Swal.fire({
    icon: 'info',
    title: 'กำลังตรวจสอบ',
    allowOutsideClick: false,
    timerProgressBar: true,
    onBeforeOpen: () => {
      Swal.showLoading()
      //  Login();
    },
  }).then((result) => {
    /* Read more about handling dismissals below */
    if (result.dismiss === Swal.DismissReason.timer) {
      console.log('I was closed by the timer')
    }
  })
}

function LogOff() {
  let task = $('input[name=task]').val()
  let redirect = ''

  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: 'btn btn-primary btn-lg m-2',
      cancelButton: 'btn btn-default btn-lg',
    },
    buttonsStyling: false,
  })

  swalWithBootstrapButtons
    .fire({
      width: '400px',
      title: 'คุณแน่ใจหรือไม่?',
      text: 'คุณต้องการออกจากระบบใช่หรือไม่?',
      icon: 'warning',
      showCancelButton: true,
      // confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'ไม่ใช่',
      confirmButtonText: 'ใช่',
    })
    .then((result) => {
      if (result.value) {
        $.ajax({
          url: 'logout.php',
          success: function (result) {
            console.log('logout sucess')

            if(task) redirect = `/${task}/index.php`
            else redirect = `index.php`
            window.location.href = `${redirect}`

            // window.location.replace(
            //   // 'https://docs.google.com/forms/d/e/1FAIpQLSdb0GZGUveX503-mMdqaez7Ttc9dQySjK_5mbW183pFAxcuVA/viewform'
            //   'live2/index.php'
            // )
          },
        })
      }
    })
}

function PlayerVimeo(src) {
  $('#clappr').html(
    '<div style="padding:56.25% 0 0 0;position:relative;"><iframe src="' +
      src +
      '" frameborder="0" allow="autoplay; fullscreen" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;"></iframe></div>'
  )
}

function PlayerClappr(src, poster_url) {
  var player = new Clappr.Player({
    source: src,
    parentId: '#clappr',
    width: '100%',
    height: '100%',
    loop : true,
    mute: true,
    autoPlay: true,
    poster: poster_url,
    plugins: [LevelSelector],
    levelSelectorConfig: {
      title: 'Quality',
      labels: {
        0: '360p',
        1: '160p',
      },
    },
    events: {
      onError: function (e) {
        $('#clappr').html(
          `<img src="${poster_url}" class="img-fluid" style="width:100%;"/>`
        )
      },
      onEnded: function () {
        console.log('Video Ended')
        // $('#clappr').hide()
        // $('#end_btn').show()
      },
    },
  })
}
