<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


if (
  isset($_POST['action']) and
  $_POST['action'] == 'export_chatlog'
) {

  if (!defined('SITE_ROOT')) {
    include_once '../../../netthai_configs.php';
    require 'path.php';
  }


  if (!isset($pdomodel)) {
    $pdomodel = new PDOModel(); //create object of the PDOModel class
    $pdomodel->connect($strHost, $strUser, $strPassword, $strDB); //connect to database
  }

  $data = $pdomodel->executeQuery(
    "SELECT 
      spuser.user_username as admin_name,
      CONCAT(spmember.member_firstname,' ', spmember.member_lastname) as member_name,
      -- spmember.member_department as 'แผนก',
      --  spmember.member_hospital as 'โรงพยาบาล',
      -- spmember.member_noid as 'เลขที่ใบประกอบโรคศิลป์/ใบประกอบวิชาชีพ',
      -- spmember.member_email as 'อีเมลล์',
      -- spmember.member_email_subscribe_state as 'สถานะสมัครรับข้อมูล',
      spchat.chat_message as 'ข้อความ',
      spchat.chat_status as 'สถานะ',
      spchat.chat_created as 'สร้างเมื่อ(ปี/เดือน/วัน เวลา)'
      FROM spchat 
      LEFT JOIN spmember ON spchat.member_id = spmember.member_id 
      LEFT JOIN spuser ON spchat.user_id = spuser.user_id 
      ORDER BY spchat.chat_created"
  );


  $styleArray = [
    'font' => [
      'bold' => true,
    ],
    'alignment' => [
      // 'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
    ],
    'borders' => [
      'top' => [
        // 'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
      ],
    ],
    'fill' => [
      'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
      'startColor' => [
        'argb' => 'CECECE',
      ]
    ],
  ];

  $filename = "chatlogs.xls";
  $spreadsheet = new Spreadsheet();
  $sheet = $spreadsheet->getActiveSheet();

  // header
  $sheet->setCellValue('A1', 'ADMIN')
    ->setCellValue('B1', 'ชื่อ - นามสกุล(สมาชิก)')
    ->setCellValue('C1', 'ข้อความ')
    ->setCellValue('D1', 'สถานะ')
    ->setCellValue('E1', 'สร้างเมื่อ(ปี/เดือน/วัน เวลา)');
  
  // set auto size. 
  foreach (range('A', 'E') as $columnID) {
    $sheet->getColumnDimension($columnID)
      ->setAutoSize(true);
  }
  // apply style to header
  $sheet->getStyle('A1:E1')->applyFromArray($styleArray);
  
  
  $sheet->fromArray($data, null, 'A2');
  $writer = new Xlsx($spreadsheet);

  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
  header('Cache-Control: max-age=0');

  $writer->save('php://output');
  exit();
}
