<?php 
require_once(__DIR__.'../../controller/controller_getChat.php'); 
$server_count_chat  = count($results);
?>


<script>
function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
        vars[key] = value;
    });
    return vars;
}
function LoadCountQuestions() {
    $.ajax({
        url: 'ajax/countChatLogs.php?r=<?=$_GET['s']?>',
        method: 'GET',
        dataType: 'json',
        success: function (data) {
            console.log(data.length);
            var count = data.length-<?=$server_count_chat?>;
            if(count != 0){
                $("#bodyCountQuestion").html('<span class="badge badge-danger">'+count+'</span>');

                
            }
        }
    }).then(function(){
        setTimeout(LoadCountQuestions, 8000);
      }
    );   
}
var stay = getUrlVars()["s"];
$(function(){
  if(stay == "pending" || typeof stay == "undefined"){
    console.log(stay);
  LoadCountQuestions();
  }
})

</script>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Q&A Management</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="index.php">Home</a></li>
              <li class="breadcrumb-item active">Q&A Management</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">

        <!-- message state -->
        <?php include(__DIR__."../../message.php"); ?>
        

        
          <div class="card">
            <div class="card-header">
            <div class="card-title">
                <a href="chatlogs.php" class="btn btn-warning" data-toggle="tooltip" title="ดึงข้อมูลใหม่">
                <i class="fas fa-sync-alt"></i> 
                <span id="bodyCountQuestion"></span>
                </a>

                <a href="chatlogs.php?s=publish" class="btn btn-success " data-toggle="tooltip" title="บทสนทนาที่เผยแพร่แล้ว">
                <i class="fas fa-check"> บทสนทนาที่เผยแพร่แล้ว</i> 
                </a>

                <a href="chatlogs.php?s=pending" class="btn btn-warning " data-toggle="tooltip" title="บทสนทนาที่รอการอนุมัติ">
                <i class="fas fa-times"> บทสนทนาที่รอการอนุมัติ</i> 
                </a>

                <a href="#" class="btn btn-danger swalConfirmDeleteAllChat" data-toggle="tooltip" title="ลบข้อมูลทั้งหมด">
                <i class="fas fa-trash"> ลบข้อมูลสนทนาทั้งหมด</i> 
                </a>
            </div>

            <div class="card-tools">
            <form method='POST' action='ajax/export_chatlogs_file.php'>
                <input type='hidden' name='action' value='export_chatlog'>
                <button type='submit' class='btn btn-info' data-toggle="tooltip" title="Export files">
                <i class="fas fa-file-export"></i>
                </a>
              </form>
            </div>

            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="dataTables-users" class="table table-bordered table-striped" >
                <thead>
                <tr>
                  <th width="10%">ID</th>
                  <th>ชื่อ - นามสกุล</th>
                  <th>ข้อความ</th>
                  <th width="20%">วัน/เวลา <?= $_GET['s'] == 'publish' ? "เผยแพร่":"" ?></th>
                  <th width="10%">สถานะ</th>
                  <th width="10%">Action</th>
                </tr>
                </thead>
                <tbody>
                <?php

                    foreach ($results as $result) {
                    if($result['user_username'] != null){
                        // admin
                        $type_user = 'admin'; 
                        $name = '<span class="badge badge-info">'.$result['user_username'].'</span>';
                    }else{
                        // member
                        $type_user = 'member';
                        $name = '<span class="badge badge-primary">'.$result['member_firstname'].' '.$result['member_lastname'].'</span>';
                    }
                    if( $_GET['s'] == 'pending' || !isset($_GET['s'])){
                      $date = $result['chat_created'];
                    }else{
                      $date = $result['chat_modify'];
                    }

                    $id_chat = $result['chat_id'];
                    $message = $result['chat_message'];
                    $status = $result['chat_status'] ? '<span class="badge badge-success">เผยแพร่</span>' : '<span class="badge badge-warning">ตรวจสอบ</span>';

                    ?>

                <tr>        
                    <td><?= $id_chat ?></td>
                    <td><?= $name ?></td>
                    <td class=""><?= $message ?></td>
                    <td><?= funcDateThai($date) ?></td>
                    <td><?= $status ?></td>
                    <td class="center">
                    <div style='display:inline-flex;' class="col-md-8">

                    <?php if($_GET['s'] == 'pending' || !isset($_GET['s'])) :?>

                            <div style='padding-left:5px;'>
                                <form method='POST' action='controller/controller_updateChatLogs.php'>
                                    <input type='hidden' name='action' value='publish'>
                                    <input type='hidden' name='chat_id' value='<?= $id_chat ?>'>
                                    <button type='submit' class='btn btn-success publish'data-toggle="tooltip" title="เผยแพร่">
                                    <i class="fas fa-check"></i>
                                    </button>
                                </form>
                            </div>

                    <?php else:?>

                            <div style='padding-left:5px;'>
                                <form method='POST' action='controller/controller_updateChatLogs.php'>
                                    <input type='hidden' name='action' value='pending'>
                                    <input type='hidden' name='chat_id' value='<?= $id_chat ?>'>
                                    <button type='submit' class='btn btn-warning' data-toggle="tooltip" title="ระงับ">
                                    <i class="fas fa-times"></i>
                                        
                                    </button>
                                </form>
                            </div>
                    <?php endif;?>

                            <!-- Remove User -->
                            <div style='padding-left:5px;'>
                                <form method='POST' action='controller/controller_deletechat.php'>
                                    <input type='hidden' name='action' value='del_chat'>
                                    <input type='hidden' name='stay' value='<?=$_GET['s']?>'>
                                    <input type='hidden' name='chat_id' value='<?= $id_chat ?>'>
                                    <button type='submit' class='btn btn-danger' data-toggle="tooltip" title="ลบข้อมูลนี้">
                                    <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>


                        </div>
                    </td>
                </tr>
                    <?php } ?>
                </tbody>
                
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->




  