<?php 
require_once(__DIR__.'../../controller/controller_getChat.php'); 
$server_count_chat  = count($results);
?>


<script>
function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
        vars[key] = value;
    });
    return vars;
}
function LoadCountQuestions() {
    $.ajax({
        url: 'ajax/countChatLogs.php?r=<?=$_GET['s']?>',
        method: 'GET',
        dataType: 'json',
        success: function (data) {
            console.log(data.length);
            var count = data.length-<?=$server_count_chat?>;
            if(count != 0){
                $("#bodyCountQuestion").html('<span class="badge badge-danger">'+count+'</span>');

                
            }
        }
    }).then(function(){
        setTimeout(LoadCountQuestions, 8000);
      }
    );   
}
var stay = getUrlVars()["s"];
$(function(){
  if(stay == "pending" || typeof stay == "undefined"){
    console.log(stay);
  LoadCountQuestions();
  }
})

</script>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Chat Management</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="index.php">Home</a></li>
              <li class="breadcrumb-item active">Chat Management</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">

        <!-- message state -->
        <?php include(__DIR__."../../message.php"); ?>
        

        
          <div class="card">
            <div class="card-header">
            <div class="card-title">
                <a href="chatlogs.php" class="btn btn-warning" data-toggle="tooltip" title="ดึงข้อมูลใหม่">
                <i class="fas fa-sync-alt"></i> 
                <span id="bodyCountQuestion"></span>
                </a>

                <a href="chatlogs.php?s=publish" class="btn btn-success " data-toggle="tooltip" title="บทสนทนาที่เผยแพร่แล้ว">
                <i class="fas fa-check"> บทสนทนาที่เผยแพร่แล้ว</i> 
                </a>

                <a href="chatlogs.php?s=pending" class="btn btn-warning " data-toggle="tooltip" title="บทสนทนาที่รอการอนุมัติ">
                <i class="fas fa-times"> บทสนทนาที่รอการอนุมัติ</i> 
                </a>

                <a href="#" class="btn btn-danger swalConfirmDeleteAllChat" data-toggle="tooltip" title="ลบข้อมูลทั้งหมด">
                <i class="fas fa-trash"> ลบข้อมูลสนทนาทั้งหมด</i> 
                </a>
            </div>

            <div class="card-tools">
            <form method='POST' action='ajax/export_chatlogs_file.php'>
                <input type='hidden' name='action' value='export_chatlog'>
                <button type='submit' class='btn btn-info' data-toggle="tooltip" title="Export files">
                <i class="fas fa-file-export"></i>
                </a>
              </form>
            </div>

            </div>
            <!-- /.card-header -->
            <div class="card-body">
           
<div id="toolbar">
<button id="remove" class="btn btn-danger" disabled>
<i class="glyphicon glyphicon-remove"></i> ลบข้อมูลที่เลือก
</button>
</div>
<table 
id="table"
data-toolbar="#toolbar"
data-id-field="member_id"
data-url="ajax/getChat.php"
data-search="true"
data-show-refresh="true"  
data-show-columns="true"
data-show-columns-toggle-all="true"
data-show-export="true"
data-click-to-select="true"
data-pagination="true"
data-page-list="[10, 25, 50, 100, all]"
data-side-pagination="server"
data-response-handler="responseHandler">
</table>

            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->




  

  <script>
      var $table = $('#table')
      var $remove = $('#remove')
      var selections = []

    function getIdSelections() {
            return $.map($table.bootstrapTable('getSelections'), function (row) {
            return row.chat_id
            })
        }


    function responseHandler(res) {
            $.each(res.rows, function (i, row) {
            row.state = $.inArray(row.chat_id, selections) !== -1
            })
            return res
        }

    function initTable() {
    $table.bootstrapTable('destroy').bootstrapTable({
      height: 500,
      columns: [
        {
          field: 'state',
          checkbox: true,
          align: 'center',
          valign: 'middle'
        }, 
        
        {
          field: 'member_name',
          title: 'ชื่อ - นามสกุล',
          sortable: false,
          align: 'center'
        }, 
        {
          field: 'chat_message',
          title: 'ข้อความ',
          sortable: false,
          align: 'center'
        }, 
        {
          field: 'chat_created',
          title: 'เวลา',
          sortable: false,
          align: 'center'
        }, 
        {
          field: 'chat_status',
          title: 'สถานะ',
          sortable: false,
          align: 'center',
          formatter: statusFormatter
        }, 
        {
          field: 'operate',
          title: 'Action',
          align: 'center',
          clickToSelect: false,
          events: window.operateEvents,
          formatter: operateFormatter
        }
      ]
    })
    $table.on('check.bs.table uncheck.bs.table ' +
      'check-all.bs.table uncheck-all.bs.table',
    function () {
      $remove.prop('disabled', !$table.bootstrapTable('getSelections').length)

      // save your data, here just save the current page
      selections = getIdSelections()
      // push or splice the selections if you want to save all data selections
    })
    $table.on('all.bs.table', function (e, name, args) {
      console.log(name, args)
    })
    $remove.click(function () {
      var ids = getIdSelections()
      console.log(ids);
      callAjaxDelMember(ids);   
      $table.bootstrapTable('remove', {
        field: 'chat_id',
        values: ids
      })
      $remove.prop('disabled', true)
    })

    }
    function statusFormatter(value, row, index){
        if(value == '1'){
        return [
            '<span class="badge badge-success" style="font-size:1rem;">อนุมัติ</span>',
        ].join('');
        }else{
        
        return [
            '<span class="badge badge-warning" style="font-size:1rem;">รอตรวจสอบ</span>',
        ].join('');
        }
    }

    function operateFormatter(value, row, index) {
    return [
      '<a class="like btn btn-info" href="javascript:void(0)" title="Like">',
      '<i class="fa fa-heart"></i>',
      '</a>  ',
      '<a class="remove btn btn-danger" href="javascript:void(0)" title="Remove">',
      '<i class="fa fa-trash"></i>',
      '</a>'
    ].join('');
  }

  window.operateEvents = {
    'click .like': function (e, value, row, index) {
      alert('You click like action, row: ' + JSON.stringify(row))
    },
    'click .remove': function (e, value, row, index) {
      callAjaxDelMember(row.chat_id);   
      $table.bootstrapTable('remove', {
        field: 'chat_id',
        values: [row.chat_id]
      })
    }
  }

  $(function() {
            // $table.bootstrapTable();
            initTable()
    })

    $('.swalConfirmDeleteAll').click(function() {
    Swal.fire({
        title: 'คำเตือน',
        text: "ต้องการลบข้อมูลบัญชีผู้ใช้งานทั้งหมดหรือไม่?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'ปิด',
        confirmButtonText: 'ใช่, ลบทั้งหมด'
      }).then((result) => {
        if (result.value) {
          window.location.href = "controller/controller_deletememberall.php";
        }
      })
    });

    function callAjaxDelMember(ids) {
        $.ajax({
            url: 'ajax/deleteMember.php',
            type: 'POST',
            data: {
                'action': 'delMember', 
                'ids': ids
                },
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            success: function (res) {
                console.log(res);
                Swal.fire({
                    icon: 'success',
                    title: 'ได้ทำรายการเรียบร้อยแล้ว',
                    showConfirmButton: false,
                    timer: 1500
                    })
                
                
                // alert(response.status);
                // alert(res);
            },
            error: function () {
                alert("error");
            }
            }); 
    }
    

</script>