<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>New User Account</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="account.php">User Account</a></li>
              <li class="breadcrumb-item active">New User Account</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- form start -->
<form role="form" id="FormAddMember" action="controller/controller_register.php" method="POST" enctype="multipart/form-data"
                    data-bv-message="This value is not valid"
                    data-bv-feedbackicons-valid="glyphicon glyphicon-ok"
                    data-bv-feedbackicons-invalid="glyphicon glyphicon-remove"
                    data-bv-feedbackicons-validating="glyphicon glyphicon-refresh">

<input type="hidden" name="action" value="addmember">


    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- left column -->
          <div class="col-md-6">
            <!-- general form elements -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Form Register</h3>
              </div>
              <!-- /.card-header -->
                <div class="card-body">
                  <!-- BODY -->

                  <div class="form-group">
                                    <label>Full Name</label>

                                          <div class="row">
                                              <div class="col-sm-6">
                                                <div class="form-group">
                                                  <input type="text" class="form-control"
                                                  name="firstName" placeholder="First name"
                                                  required data-bv-notempty-message="The first name is required and cannot be empty"
                                                  pattern="[ก-ฮa-zA-Z_\.]+" data-bv-regexp-message="The username can only consist of alphabetical, number, dot and underscore" />
                                                  </div>
                                              </div>
                                              <div class="col-sm-6">
                                               <div class="form-group">
                                                  <input type="text" class="form-control" name="lastName" placeholder="Last name"
                                                  required data-bv-notempty-message="The last name is required and cannot be empty"
                                                  pattern="[ก-ฮa-zA-Z_\.]+" data-bv-regexp-message="The username can only consist of alphabetical, number, dot and underscore" />
                                                  </div>
                                              </div>
                                            </div>
                                     </div>
                                     


                                        <div class="form-group">
                                            <label>Username</label>
                                                <input type="text" class="form-control" name="username"
                                                   data-bv-message="The username is not valid"
                                                   required data-bv-notempty-message="The username is required and cannot be empty"
                                                   pattern="[a-zA-Z0-9_\.]+" data-bv-regexp-message="The username can only consist of alphabetical, number, dot and underscore"
                                                   data-bv-stringlength="true" data-bv-stringlength-min="6" data-bv-stringlength-max="30" data-bv-stringlength-message="The username must be more than 6 and less than 30 characters long"
                                                   data-bv-different="true" data-bv-different-field="password" data-bv-different-message="The username and password cannot be the same as each other"
                                                   data-bv-remote="true" data-bv-remote-url="remote.php" data-bv-remote-message="The username is not available"
                                                    />
                                            <!-- <p class="help-block"><em>Signal : [ip:port/channel]</em></p> -->
                                        </div>
                                        <div class="form-group">
                                            <label>Password</label>
                                            <input type="password" class="form-control" name="password"
                                   required data-bv-notempty-message="The password is required and cannot be empty"
                                   data-bv-identical="true" data-bv-identical-field="confirmPassword" data-bv-identical-message="The password and its confirm are not the same"
                                   data-bv-different="true" data-bv-different-field="username" data-bv-different-message="The password cannot be the same as username"/>
                                        </div>
                                         <div class="form-group">
                                            <label>Verify Password</label>
                                            <input type="password" class="form-control" name="confirmPassword"
                                   required data-bv-notempty-message="The confirm password is required and cannot be empty"
                                   data-bv-identical="true" data-bv-identical-field="password" data-bv-identical-message="The password and its confirm are not the same"
                                   data-bv-different="true" data-bv-different-field="username" data-bv-different-message="The password cannot be the same as username"/>
                                        </div>


                                          <div class="row">
                                              <div class="col-xs-6">
                                                       <div class="form-group">
                                                  <label>Status</label>
                                                  <div class="radio">
                                                      <label>
                                                          <input type="radio" name="member_status" id="optionsRadios1" value="true" checked> Activate
                                                      </label>
                                                  </div>
                                                  <div class="radio">
                                                      <label>
                                                          <input type="radio" name="member_status" id="optionsRadios2" value="false"> Deactivate
                                                      </label>
                                                  </div>
                                                  </div>
                                              </div>
                                              <!-- <div class="col-xs-6">
                                                     <div class="form-group">
                                                      <label>Time Status</label>
                                                      <div class="radio">
                                                          <label>
                                                              <input type="radio" name="member_time" id="optionsRadios1" value="true" checked>All time
                                                          </label>
                                                      </div>
                                                      <div class="radio">
                                                          <label>
                                                              <input type="radio" name="member_time" id="optionsRadios2" value="false">Deactivate in 24 hour
                                                          </label>
                                                      </div>
                                                  </div>
                                              </div> -->
                        </div>

                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                <button type="submit" class="btn btn-success"><i class="fa fa-check fa-fw"></i> Save</button>
                <button type="reset" class="btn btn-danger" onclick="reset()" id="reset"><i class="fa fa-times fa-fw"></i> Reset</button>
                </div>
            </div>
            <!-- /.card -->
          </div>
          <!--/.col (left) -->

          <!-- right column -->
          <div class="col-md-6">
            <!-- general form elements disabled -->
            <div class="card card-warning">
              <div class="card-header">
                <h3 class="card-title">File Image Display</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <form role="form">
                  <div class="row">
                    <div class="col-sm-6">
                      <!-- text input -->
                      <div class="form-group">
                        <!-- <label>File Image Display</label> -->
                        <br/>
                        <img id="blah" src="../images/noavatar.jpg" alt="image display" width="150" height="150" class="img-thumbnail"/>
                        </div>
                    </div>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <input type="file" name="member_pic" onchange="readURL(this);">
                            <label>(support files: JPG, JPEG, GIF, PNG)</label>
                        </div>
                    </div>
                </div>

                </form>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            
          </div>
          <!--/.col (right) -->
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  </form>




<script type="text/javascript">

   $('#FormAddMember').bootstrapValidator();

</script>


  <script>
    function readURL(input) {
         if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
              $('#blah')
                .attr('src', e.target.result)
                .width(150)
                .height(150);
            };
    reader.readAsDataURL(input.files[0]);
  }
}
</script>




<script type="text/javascript">

    function reset(){
        $('#reset').reset();
    }
</script>
<!--End Form Validation-->
