<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Statistics</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active">Report</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">



                <!-- message state -->
                <?php include(__DIR__."../../message.php"); ?>
                <?php require_once(__DIR__.'../../controller/controller_getStatistics.php'); ?>
                <?php require_once(__DIR__.'../../controller/controller_getmember.php'); ?>
                <?php require_once(__DIR__.'../../controller/controller_getfiles.php'); ?>


                <div class="row">
                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">User Account</span>
                                <span class="info-box-number"><?=$user_count?></span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <!-- /.col -->
                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-success"><i class="fas fa-users"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">User Online</span>
                                <span class="info-box-number" id="userOnlineSpan1"><?=$user_online_count?></span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <!-- /.col -->

                    <!-- /.col -->
                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-danger"><i class="far fa-star"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">Login Total</span>
                                <span class="info-box-number"><?=$totalLoginCount?></span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <!-- /.col -->
                </div>
                <div class="row">

                    <div class="col-md-6">
                        <div class="card card-primary">
                            <div class="card-header">
                                รายงานสรุป ประเภทที่ 1 (บันทึกทุกการใช้งาน)
                            </div>

                            <div class="card-body">

                                <div class="form-group">
                                    <a href="statistic_type1.php?action=today" class="btn btn-block btn-warning"><i
                                            class="fas fa-chart-bar"></i> Today Report (รายงานเฉพาะวันนี้)</a>
                                    <a href="statistic_type1.php?action=daily" class="btn btn-block btn-warning"><i
                                            class="fas fa-chart-bar"></i> Daily Report (รายงานทุกวัน)</a>
                                </div>

                                <form action="statistic_type1.php" method="get">
                                    <input type="hidden" name="action" value="date">
                                    <!-- Date range -->
                                    <div class="form-group">
                                        <label>เลือกช่วงเวลา</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="far fa-calendar-alt"></i>
                                                </span>
                                            </div>
                                            <input type="text" class="form-control float-right" id="reservation"
                                                name="date">
                                        </div>

                                        <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-success"></i> Submit</button>
                            </div>
                            </form>


                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card card-primary">
                            <div class="card-header">
                                รายงานสรุป ประเภทที่ 2 (การใช้งานรายบุคคล)
                            </div>

                            <div class="card-body">
                                <a href="statistic_type2.php?action=today" class="btn btn-block btn-warning"><i
                                        class="fas fa-chart-bar"></i> Today Report (รายงานเฉพาะวันนี้)</a>
                                <a href="statistic_type2.php?action=daily" class="btn btn-block btn-warning"><i
                                        class="fas fa-chart-bar"></i> Daily Report (รายงานทุกวัน)</a>
                            </div>

                        </div>




                    </div>

                    <!-- /.col -->
                </div>

        

    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->



<script>
$(function(){
    loadUserOnline();
    console.log('loadUserOnline()');
})

function loadUserOnline() {
    $.ajax({
        url: 'ajax/getUserOnline.php',
        method: 'POST',
        dataType: 'json',
        success: function(data) {
            console.log(data);
            var pathPic = "";
            var body = "";
            $("#bodyUserOnline").html('');
            if (data.length == 0) {
                $("#bodyUserOnline").html('<h5>There are no users at this time. </h5');
            }
            $("#userOnlineSpan1").html(data.length);
        }
    }).then(function() {
        setTimeout(loadUserOnline, 10000);
    });
}

</script>




