<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <?php include('controller/mailsender.php'); ?>
                    <h1>Mail Sender</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="account.php">Home</a></li>
                        <li class="breadcrumb-item active">Mail Sender Setting</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- form start -->
    <form role="form" id="FormAddMember" action="" method="POST" enctype="multipart/form-data"
        data-bv-message="This value is not valid" data-bv-feedbackicons-valid="glyphicon glyphicon-ok"
        data-bv-feedbackicons-invalid="glyphicon glyphicon-remove"
        data-bv-feedbackicons-validating="glyphicon glyphicon-refresh">

        <input type="hidden" name="action" value="editmail">

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <!-- left column -->
                    <div class="col-md-12">
                        <!-- general form elements -->
                        <div class="card card-defualt">

                            <!-- /.card-header -->
                            <div class="card-body">


                                <div class="form-group">


                                    <label for="email">Email Subject</label>
                                    <input type="text" class="form-control" id="subject" name="subject" value="<?=$arr[0]['subject']?>"
                                            placeholder="Email Subject">

                                </div>



                                <div class="form-group">


                                    <label for="email">Email Description Form</label>
                                    <textarea class="textareaEditor" placeholder="Place some text here" name="editor"
                                        id="editor"
                                        style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">
                                        <?=$arr[0]['html']?>
                                        </textarea>

                                </div>

                                <div class="form-group">
                                    <label for="email">Email address (for test)</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="email" name="email"
                                            placeholder="Enter email">
                                        <span class="input-group-append">
                                            <button type="button" onclick="testSendMail()"  class="btn btn-info btn-flat"><i
                                                    class="fas fa-paper-plane"></i> Test Mail Sender</button>
                                        </span>
                                    </div>

                                </div>


                            </div>
                            <!-- /.card-body -->

                            <div class="card-footer">
                                <button type="button" onclick="save()" class="btn btn-success">
                                    <i class="fas fa-check"></i> Save</button>

                                <button type="button" onclick="LoadDialog()" class="btn btn-warning float-right">
                                    <i class="fas fa-paper-plane"></i> Send Mail All</button>


                            </div>
                        </div>
                        <!-- /.card -->
                    </div>
                    <!--/.col (left) -->



                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content -->
</div>
<!-- /.content-wrapper -->
</form>

<!-- ########### -->
<script type="text/javascript">

function LoadDialog() {
    Swal.fire({
        icon: 'info',
        title: 'กำลังตรวจสอบ',
        html: 'ระบบกำลังดำเนินการส่งอีเมล์ไปยังผู้ใช้งานทั้งหมด <br>อาจใช้เวลาสักครู่..',
        allowOutsideClick: false,
        timerProgressBar: true,
        onBeforeOpen: () => {
            Swal.showLoading()
            sendMailAll();
        }
    }).then((result) => {
        /* Read more about handling dismissals below */
        if (result.dismiss === Swal.DismissReason.timer) {
            console.log('I was closed by the timer')
        }
    })
}

function testSendMail(){
    let email = $('input#email').val();
    let editor = $('textarea#editor').val();
    let subject = $('input#subject').val();
    // console.log(email);
    // console.log(subject);
    // console.log(editor);

    if(email){
        $.ajax({
        url: 'controller/mailsender.php',
        type: 'post',
        dataType: 'JSON',
        data: {
            'action': 'test_mailsender',
            'editor': editor,
            'subject': subject,
            'email' : email
        },
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(res) {
            console.log(res);
            switch (res.status) {
                case "success":
                    Swal.fire(
                        'สำเร็จ',
                        'ระบบกำลังดำเนินการส่งเมล์ไปยังปลายทาง อาจใช้เวลา 2-3 นาที',
                        'success'
                    )
                    break;
                case "failure":
                    Swal.fire(
                        'เอ๊ะ..พบปัญหา',
                        'กรุณาตรวจสอบข้อมูล E-mail ของท่าน',
                        'warning'
                    )
                    break;

                default:
                    Swal.fire(
                        'เกิดข้อผิดพลาด!',
                        'เกิดข้อผิดพลาดระหว่างการติดต่อกับเซิฟเวอร์!',
                        'error'
                    )
                    break;
            }
        },
        error: function(e) {
            console.log(e);
        }
    });
    }else{
        Swal.fire(
                        'เอ๊ะ..พบปัญหา',
                        'กรุณาตรวจสอบข้อมูล E-mail ของท่าน',
                        'warning'
                    )
    }

}

function sendMailAll(){
    let editor = $('textarea#editor').val();
    let subject = $('input#subject').val();

    $.ajax({
        url: 'controller/mailsender.php',
        type: 'post',
        dataType: 'JSON',
        data: {
            'action': 'all_mailsender',
            'editor': editor,
            'subject': subject
        },
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(res) {
            console.log(res);
            if(res.status == "success"){
                Swal.fire(
                        'สำเร็จ',
                        'ส่งข้อมูลไปยังบัญชีผู้ใช้งานทั้งหมดแล้ว',
                        'success'
                    )
            }else{
                Swal.fire(
                        'เกิดข้อผิดพลาด!',
                        'เกิดข้อผิดพลาดระหว่างการติดต่อกับเซิฟเวอร์!',
                        'error'
                    )
            }
        },
        error: function(e) {
            console.log(e);
        }
    });
}


function save() {
    let editor = $('textarea#editor').val();
    let subject = $('input#subject').val();

   
    
    $.ajax({
        url: 'controller/mailsender.php',
        type: 'post',
        dataType: 'JSON',
        data: {
            'action': 'edit_mailsender',
            'editor': editor,
            'subject': subject
        },
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(res) {
            console.log(res);
            switch (res.status) {
                case "success":
                    Swal.fire(
                        'สำเร็จ',
                        'บันทึกข้อมูลเรียบร้อยแล้ว',
                        'success'
                    )
                    break;
                case "notchange":
                    Swal.fire(
                        'เอ๊ะ..พบปัญหา',
                        'ไม่พบข้อมูลเปลี่ยนแปลง',
                        'warning'
                    )
                    break;

                default:
                    Swal.fire(
                        'เกิดข้อผิดพลาด!',
                        'เกิดข้อผิดพลาดระหว่างการติดต่อกับเซิฟเวอร์!',
                        'error'
                    )
                    break;
            }
        },
        error: function(e) {
            console.log(e);
        }
    });
    

}
</script>

<!--End Form Validation-->