<?php
header('Content-type:application/json;charset=utf-8');
require_once(__DIR__ . "../../checkSession.php");

if (!defined('SITE_ROOT')) {
    include_once '../../../netthai_configs.php';
    require 'path.php';
}

$page_name = trim($_POST['page_name']);
$video_name = trim($_POST['video_name']);
$video_link = trim($_POST['video_link']);
$speaker_info = trim($_POST['speaker_info']);

$page_status = $_POST['page_status'];
$btn_login_status = $_POST['login_status'];
$page_action = trim($_POST['page_action']);
$page_id = $_POST['page_id'];

$protocol = array('http://', 'https://');

if(!contains($video_link, $protocol)){
    $video_link = $protocol[0] . $video_link;
}



if (!$page_name) {
    echo json_encode([
        'status' => 'error',
        'error' => $pdomodel->error,
        'message' => 'input invalid.'
    ]);
    exit();
} else {
    if ($page_action == 'new') {

        $pdomodel->select("ui_page");
        if($pdomodel->totalRows == 500){
            echo json_encode([
                'status' => 'limit_page',
                'error' => $pdomodel->error,
                'message' => sprintf('%s ไม่สามารถสร้าง Directory ได้อีกต่อไป', $page_name)
            ]);
            exit();
        }

        $pdomodel->where("page_name", $page_name);
        $pdomodel->select("ui_page");
        if ($pdomodel->totalRows) {
            echo json_encode([
                'status' => 'already',
                'error' => $pdomodel->error,
                'message' => sprintf('%s มีอยู่แล้วในฐานข้อมูล โปรดใช้ชื่ออื่น', $page_name)
            ]);
            exit();
        }

       // handler Protect make overwrite same main directory.
       handlerProtectDirectoryWirte($page_name);


        // insert new record to db.
        $insertData = array(
            "page_name" => $page_name,
            "page_topic_video" => $video_name,
            "page_video_link" => $video_link,
            "page_speaker_info" => $speaker_info,
            "page_created_at" => $datetime_now,
            "page_status" => $page_status,
            "btn_login_status" => $btn_login_status,
            "page_url" => $base_url . $page_name
        );

        $pdomodel->insert("ui_page", $insertData);

        if ($pdomodel->rowsChanged  == 1) {

            //create file
            createFile(
                $pathUpload,
                $page_name,
                $pdomodel->lastInsertId
            );

            echo json_encode([
                'status' => 'ok',
                'error' => $pdomodel->error,
                'message' => 'insert link poll successfuly.'
            ]);
            exit();
        } else {
            echo json_encode([
                'status' => 'not_change',
                'error' => $pdomodel->error,
                'message' => 'not have new data.'
            ]);
            exit();
        }
    } else if ($page_action == 'update') {

        $pdomodel->where("page_name", $page_name);
        $result = $pdomodel->select("ui_page");
        // handler recourd self
        if ($result[0]['page_id'] != $page_id) {
            if ($pdomodel->totalRows) {
                echo json_encode([
                    'status' => 'already',
                    'error' => $pdomodel->error,
                    'message' => sprintf('%s มีอยู่แล้วในฐานข้อมูล โปรดใช้ชื่ออื่น', $page_name)
                ]);
                exit();
            }
        }
       
        // handler Protect make overwrite same main directory.
        handlerProtectDirectoryWirte($page_name);

        // Retrieve old directory name and Rename directory 
        $pdomodel->where("page_id", $page_id);
        $result = $pdomodel->select("ui_page");
        $oldName = $pathUpload.$result[0]['page_name'];
        if(! rename($oldName, $pathUpload.$page_name)){
            echo json_encode([
                'status' => 'error',
                'oldName' => $oldName,
                'newName' => $pathUpload.$page_name,
                'error' => 'ไม่พบไฟล์หรือข้อมูล, ข้อมูลอาจสูญหาย โปรดติดต่อผู้ดูแล'
            ]);
            exit();
        }

        $updateData = array(
            "page_name" => $page_name,
            "page_topic_video" => $video_name,
            "page_video_link" => $video_link,
            "page_speaker_info" => $speaker_info,
            "page_updated_at" => $datetime_now,
            "page_status" => $page_status,
            "btn_login_status" => $btn_login_status,
            "page_url" => $base_url . $page_name
        );
        $pdomodel->where("page_id", $page_id);
        $pdomodel->update("ui_page", $updateData);
        if ($pdomodel->rowsChanged == 0) {
            //not change
            echo json_encode([
                'status' => 'not_change',
                'error' => $pdomodel->error,
                'message' => 'ไม่พบการเปลี่ยนแปลง'
            ]);
            exit();
        } else {
            //updated 
            echo json_encode([
                'status' => 'ok',
                'error' => $pdomodel->error,
                'message' => 'updated link poll successfuly.'
            ]);
            exit();
        }
    }
}

function handlerProtectDirectoryWirte($name)
{
    $dont_touch = array('AdminLTE-3.0.1', 'ajax', 'backend', 'bootstrap', 'bower_components', 'cgi-bin', 'chatv1', 'controller', 'dist', 'filedemand2', 'ftemplate', 'images', 'img', 'jwplayer-7.6.0', 'live1', 'mockup', 'poll', 'poll_script', 'resources', 'script', 'uploads');
         if (in_array($name, $dont_touch)) {
             echo json_encode([
                 'status' => 'already_directory',
                 'message' => sprintf('%s โปรดใช้ชื่ออื่นในการสร้าง Directory Page', $name)
             ]);
             exit();
         }
}

function createFile($pathUpload, $name, $id)
{
    if (!is_dir($pathUpload . $name)) {
        // mkdir($name);
        recurse_copy($pathUpload . 'mockup', $pathUpload . $name);
    }

    $data = array(
        "page_id" => $id
    );

    $filePath = $pathUpload . $name . "/config.json";
    $myfile = fopen($filePath, "w") or die("Unable to open file!");
    fwrite($myfile, json_encode($data));
    fclose($myfile);
}

function recurse_copy($src, $dst)
{
    $dir = opendir($src);
    @mkdir($dst);
    while (false !== ($file = readdir($dir))) {
        if (($file != '.') && ($file != '..')) {
            if (is_dir($src . '/' . $file)) {
                recurse_copy($src . '/' . $file, $dst . '/' . $file);
            } else {
                copy($src . '/' . $file, $dst . '/' . $file);
            }
        }
    }
    closedir($dir);
}

function contains($str, array $arr)
{
    foreach($arr as $a) {
        if (stripos($str,$a) !== false) return true;
    }
    return false;
}