<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


if (
    isset($_POST['action']) and
    $_POST['action'] == 'export_account'
) {

    if (!defined('SITE_ROOT')) {
        include_once '../../../netthai_configs.php';
        require 'path.php';
    }


    if (!isset($pdomodel)) {
        $pdomodel = new PDOModel(); //create object of the PDOModel class
        $pdomodel->connect($strHost, $strUser, $strPassword, $strDB); //connect to database
    }

    $data = $pdomodel->executeQuery(
        "SELECT 
        spmember.member_firstname,
        spmember.member_lastname,
        spmember.member_email as 'E-Mail', 
        IF(spmember.member_career = 'Others', concat(spmember.member_career,' | ',spmember.member_career_other), spmember.member_career) as member_career,
        spmember.member_hospital,
        spmember.member_province,
        ui_page.page_name,
        DATE_FORMAT(spmember.member_register, '%d-%m-%Y %H:%i:%s')
      FROM spmember
      INNER JOIN ui_page 
      ON  ui_page.page_id = spmember.page_id
      ORDER BY spmember.member_register;"
    );

    $filename = $project_name . "-" . $_POST['action'] . '-' . date("d-m-Y");

    // Initialize
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Initialize
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Style
    $sheet->getStyle('A1:H1')->applyFromArray(headerStyle());
    foreach (range('A', 'H') as $columnID) {
        $sheet->getColumnDimension($columnID)
            ->setAutoSize(true);
    }
    // Header & Data body
    $headerArray = [
        'First name',
        'Last name',
        'Email address',
        'Specialty',
        'Hospital',
        'Province',
        'Directory Form',
        'Registration(dd/mm/yy)'
    ];

    $sheet->fromArray($headerArray, null, 'A1');
    $sheet->fromArray($data, null, 'A2');
    $writer = new Xlsx($spreadsheet);

    // Header script
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    exit();
}


function headerStyle()
{
    return $style = [
        'font' => [
            'bold' => true,
        ],
        'alignment' => [
            // 'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
        ],
        'borders' => [
            'top' => [
                // 'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            ],
        ],
        'fill' => [
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'startColor' => [
                'argb' => 'CECECE',
            ]
        ],
    ];
}
