<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


if (isset($_POST['action'])) {

  if (!defined('SITE_ROOT')) {
    include_once '../../../netthai_configs.php';
    require 'path.php';
  }


  if (!isset($pdomodel)) {
    $pdomodel = new PDOModel(); //create object of the PDOModel class
    $pdomodel->connect($strHost, $strUser, $strPassword, $strDB); //connect to database
  }

  $str1 = "SELECT
      -- @rownum := @rownum + 1 as 'ลำดับ',
      -- spmember.member_id as 'ID',
      spmember.member_firstname,
      spmember.member_lastname,
      spmember.member_email as 'E-Mail', 
      IF(member_career = 'Other', concat(member_career,' | ',member_career_other), member_career) as member_career,

      min(stats.stats_created) as 'วันบันทึกสถิติครั้งแรก',
      max(stats.stats_logon_day) as 'เวลาเริ่มใช้งาน(ล่าสุด)',
      max(stats.stats_logon_end) as 'สิ้นสุดการใช้งาน(ล่าสุด)',
      SEC_TO_TIME( SUM( TIME_TO_SEC( stats.stats_logon_stay ) ) ) as 'เวลาอยู่ในระบบ(ชั่วโมง/นาที/วินาที)',
      COUNT(*) as 'จำนวนครั้งเข้าระบบ'
      FROM (select @rownum := 0) r,stats";

  if ($_POST['action'] == 'daily')
    $str2 = "INNER JOIN spmember on stats.member_id = spmember.member_id GROUP BY spmember.member_id ORDER BY stats.stats_logon_day DESC";
  else if ($_POST['action'] == 'today')
    $str2 = "INNER JOIN spmember on stats.member_id = spmember.member_id WHERE date(stats_logon_day) = curdate() GROUP BY spmember.member_id ORDER BY stats.stats_logon_day DESC";

  $data = $pdomodel->executeQuery($str1 . ' ' . $str2);


  $filename = $project_name."-stats-T2-" . $_POST['action'] . '-' . date("d-m-Y");

  // Initialize
  $spreadsheet = new Spreadsheet();
  $sheet = $spreadsheet->getActiveSheet();

  // Style
  $sheet->getStyle('A1:I1')->applyFromArray(headerStyle());
  foreach (range('A', 'I') as $columnID) {
    $sheet->getColumnDimension($columnID)
      ->setAutoSize(true);
  }
  // Header & Data body
  $headerArray = [
    'First name',
    'Last name',
    'Email address',
    'Department',

    'วันบันทึกสถิติครั้งแรก',
    'เวลาเริ่มใช้งาน(ล่าสุด)',
    'สิ้นสุดการใช้งาน(ล่าสุด)',
    'เวลาอยู่ในระบบ(ชั่วโมง/นาที/วินาที)',
    'จำนวนครั้งเข้าระบบ'
  ];

  $sheet->fromArray($headerArray, null, 'A1');
  $sheet->fromArray($data, null, 'A2');
  $writer = new Xlsx($spreadsheet);

  // Header script
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
  header('Cache-Control: max-age=0');

  $writer->save('php://output');
  exit();
}

function headerStyle()
{
  return $style = [
    'font' => [
      'bold' => true,
    ],
    'alignment' => [
      // 'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
    ],
    'borders' => [
      'top' => [
        // 'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
      ],
    ],
    'fill' => [
      'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
      'startColor' => [
        'argb' => 'CECECE',
      ]
    ],
  ];
}
