<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if (isset($_POST['action'])) {

  if (!defined('SITE_ROOT')) {
    include_once '../../../netthai_configs.php';
    require 'path.php';
  }

 
  $type = trim($_POST['type']);
  $time = trim($_POST['time']);

  if ($type == 'full') {
    // Full Stats
    if ($time == 'all') {
      // All Report
      getStatsFull_all($pdomodel, $_POST['page'], $project_name);
    } else {
      // Date Rang
      getStatsFull_date($pdomodel, $_POST['page'], $_POST['date'], $project_name);
      //
    }
  } else {
    // Group by user
    if ($time == 'all') {
      // All Report
      getStatsGroup_all($pdomodel, $_POST['page'], $project_name);
    } else {
      // Date Rang
      getStatsGroup_date($pdomodel, $_POST['page'], $_POST['date'], $project_name);
    }
  }
}

// Style Export
function headerStyle()
{
  return $style = [
    'font' => [
      'bold' => true,
    ],
    'alignment' => [
      // 'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
    ],
    'borders' => [
      'top' => [
        // 'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
      ],
    ],
    'fill' => [
      'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
      'startColor' => [
        'argb' => 'CECECE',
      ]
    ],
  ];
}

function getStatsFull_all($pdomodel, $pageParams, $project_name)
{
  $pages = explode('|', $pageParams);
  $page_id = $pages[0];


  $data = $pdomodel->executeQuery(
    "SELECT 
        spmember.member_firstname,
        spmember.member_lastname,
        spmember.member_email,
        IF(spmember.member_career = 'Others', concat(spmember.member_career,' | ',spmember.member_career_other), spmember.member_career) as member_career,
        spmember.member_hospital,
        spmember.member_province,
        ui_page.page_name,
        DATE_FORMAT(stats_video.created_at, '%d-%m-%Y %H:%i:%s')
      FROM stats_video 
      INNER JOIN spmember on stats_video.member_id = spmember.member_id 
      INNER JOIN ui_page on stats_video.page_id = ui_page.page_id 
      WHERE stats_video.page_id = ?",
    array(
      $page_id
    )
  );
  exportType1($data, $project_name);
}

function getStatsFull_date($pdomodel, $pageParams, $dateParams, $project_name)
{
  $pages = explode('|', $pageParams);
  $page_id = $pages[0];
  $dates = explode(" - ", $dateParams);
  $startDate = str_replace("/", "-", $dates[0]);
  $dateStarts = explode("-", $startDate);
  $EndDate = str_replace("/", "-", $dates[1]);
  $dateEnds = explode("-", $EndDate);

  $resultDateStart = $dateStarts[2] . "-" . $dateStarts[1] . "-" . $dateStarts[0];
  $resultDateEnd = $dateEnds[2] . "-" . $dateEnds[1] . "-" . $dateEnds[0];

  $data = $pdomodel->executeQuery(
    "SELECT 
        spmember.member_firstname,
        spmember.member_lastname,
        spmember.member_email,
        IF(spmember.member_career = 'Others', concat(spmember.member_career,' | ',spmember.member_career_other), spmember.member_career) as member_career,
        spmember.member_hospital,
        spmember.member_province,
        ui_page.page_name,
        DATE_FORMAT(stats_video.created_at, '%d-%m-%Y %H:%i:%s')
      FROM stats_video 
      INNER JOIN spmember on stats_video.member_id = spmember.member_id 
      INNER JOIN ui_page on stats_video.page_id = ui_page.page_id 
      WHERE stats_video.page_id = ? 
      AND (date(stats_video.created_at) BETWEEN ? AND ?)",
    array(
      $page_id,
      $resultDateStart,
      $resultDateEnd
    )
  );
  exportType1($data, $project_name);
}

function getStatsGroup_all($pdomodel, $pageParams, $project_name)
{
  $pages = explode('|', $pageParams);
  $page_id = $pages[0];


  $data = $pdomodel->executeQuery(
    "SELECT 
        spmember.member_firstname,
        spmember.member_lastname,
        spmember.member_email,
        IF(spmember.member_career = 'Others', concat(spmember.member_career,' | ',spmember.member_career_other), spmember.member_career) as member_career,
        spmember.member_hospital,
        spmember.member_province,
        ui_page.page_name,
        COUNT(*) as 'จำนวนครั้งเข้าระบบ',
        DATE_FORMAT(min(stats_video.created_at), '%d-%m-%Y %H:%i:%s'),
        DATE_FORMAT(max(stats_video.created_at), '%d-%m-%Y %H:%i:%s')
      FROM stats_video 
      INNER JOIN spmember on stats_video.member_id = spmember.member_id 
      INNER JOIN ui_page on stats_video.page_id = ui_page.page_id 
      WHERE stats_video.page_id = ?
      GROUP BY spmember.member_id",
    array(
      $page_id
    )
  );
  exportType2($data, $project_name);
}

function getStatsGroup_date($pdomodel, $pageParams, $dateParams, $project_name)
{
  $pages = explode('|', $pageParams);
  $page_id = $pages[0];
  $dates = explode(" - ", $dateParams);
  $startDate = str_replace("/", "-", $dates[0]);
  $dateStarts = explode("-", $startDate);
  $EndDate = str_replace("/", "-", $dates[1]);
  $dateEnds = explode("-", $EndDate);

  $resultDateStart = $dateStarts[2] . "-" . $dateStarts[1] . "-" . $dateStarts[0];
  $resultDateEnd = $dateEnds[2] . "-" . $dateEnds[1] . "-" . $dateEnds[0];

  $data = $pdomodel->executeQuery(
    "SELECT 
        spmember.member_firstname,
        spmember.member_lastname,
        spmember.member_email,
        IF(spmember.member_career = 'Others', concat(spmember.member_career,' | ',spmember.member_career_other), spmember.member_career) as member_career,
        spmember.member_hospital,
        spmember.member_province,
        ui_page.page_name,
        COUNT(*) as 'จำนวนครั้งเข้าระบบ',
        DATE_FORMAT(min(stats_video.created_at), '%d-%m-%Y %H:%i:%s'),
        DATE_FORMAT(max(stats_video.created_at), '%d-%m-%Y %H:%i:%s')
      FROM stats_video 
      INNER JOIN spmember on stats_video.member_id = spmember.member_id 
      INNER JOIN ui_page on stats_video.page_id = ui_page.page_id 
      WHERE stats_video.page_id = ? 
      AND (date(stats_video.created_at) BETWEEN ? AND ?)
      GROUP BY spmember.member_id",
    array(
      $page_id,
      $resultDateStart,
      $resultDateEnd
    )
  );
  exportType2($data, $project_name);
}

// Export Funcation
function exportType1($data, $project_name)
{
  $filename = $project_name . "-stats-T1-"  . '-' . date("d-m-Y");

  // Initialize
  $spreadsheet = new Spreadsheet();
  $sheet = $spreadsheet->getActiveSheet();

  // Style
  $sheet->getStyle('A1:H1')->applyFromArray(headerStyle());
  foreach (range('A', 'H') as $columnID) {
    $sheet->getColumnDimension($columnID)
      ->setAutoSize(true);
  }
  // Header & Data body
  $headerArray = [
    'First name',
    'Last name',
    'Email address',
    'Specialty',
    'Hospital',
    'Province',
    'Directory',

    'วันที่บันทึกสถิติ(ว/ด/ป)'
  ];

  $sheet->fromArray($headerArray, null, 'A1');
  $sheet->fromArray($data, null, 'A2');
  $writer = new Xlsx($spreadsheet);

  // Header script
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
  header('Cache-Control: max-age=0');

  $writer->save('php://output');
  exit();
}
function exportType2($data, $project_name)
{
  $filename = $project_name . "-stats-T2-"  . '-' . date("d-m-Y");

  // Initialize
  $spreadsheet = new Spreadsheet();
  $sheet = $spreadsheet->getActiveSheet();

  // Style
  $sheet->getStyle('A1:J1')->applyFromArray(headerStyle());
  foreach (range('A', 'J') as $columnID) {
    $sheet->getColumnDimension($columnID)
      ->setAutoSize(true);
  }
  // Header & Data body
  $headerArray = [
    'First name',
    'Last name',
    'Email address',
    'Specialty',
    'Hospital',
    'Province',
    'Directory',
    'จำนวนการเข้าชม(ครั้ง)',
    'วันที่เริ่มบันทึกสถิติ(ว/ด/ป)',
    'วันที่ล่าสุดบันทึกสถิติ(ว/ด/ป)'
  ];

  $sheet->fromArray($headerArray, null, 'A1');
  $sheet->fromArray($data, null, 'A2');
  $writer = new Xlsx($spreadsheet);

  // Header script
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
  header('Cache-Control: max-age=0');

  $writer->save('php://output');
  exit();
}
