<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Statistics</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                        <li class="breadcrumb-item active">Report</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">

                <!-- message state -->
                <?php include(__DIR__ . "../../message.php"); ?>
                <?php //require_once(__DIR__.'../../controller/controller_getStatistics.php'); 
                ?>
                <?php //require_once(__DIR__.'../../controller/controller_getmember.php'); 
                ?>
                <?php require_once(__DIR__ . '../../controller/getStatisticsVideo.php'); ?>



                <div class="row">
                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">User Account</span>
                                <span class="info-box-number"><?= $user_count ?></span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <!-- /.col -->
                    
                    

                    <!-- /.col -->
                    <div class="col-md-3 col-sm-6 col-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-danger"><i class="far fa-star"></i></span>

                            <div class="info-box-content">
                                <span class="info-box-text">Login Total</span>
                                <span class="info-box-number"><?= $totalLoginCount ?></span>
                            </div>
                            <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                    <!-- /.col -->
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <form action="ajax/export_stats_video.php" method="POST">
                            <input type="hidden" name="action" value="date">
                            <div class="card card-primary">
                                <div class="card-header">
                                    Video Demand Report (ตั้งค่ารายงาน)
                                </div>

                                <div class="card-body">

                                    <div class="form-group">
                                        <label for="">Step 1. ประเภทรายงาน</label>
                                        <div class="form-check">
                                            <label class="form-check-label">
                                                <input type="radio" class="form-check-input" name="type" id="" value="full" checked>
                                                แสดงแบบละเอียด ทุกรายการ
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <label class="form-check-label">
                                                <input type="radio" class="form-check-input" name="type" id="" value="group">
                                                แสดงสรุปรวมแต่ละคน
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="">Step 2. Directory Page</label>
                                        <select class="form-control select2" name="page" id="" required>
                                            <option value="" selected>** กรุณาเลือกข้อมูลที่สนใจ **</option>
                                            <?php foreach ($resultPages as $page) : ?>
                                                <option value="<?= $page['page_id'] . '|' . $page['page_name'] ?>"><?= $page['page_name'] ?></option>
                                            <?php endforeach ?>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="">Step 3. ช่วงเวลา</label>
                                        <div class="form-check">
                                            <label class="form-check-label">
                                                <input type="radio" class="form-check-input" name="time" id="" value="all" checked>
                                                ทั้งหมด
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <label class="form-check-label">
                                                <input type="radio" class="form-check-input" name="time" id="" value="time">
                                                ช่วงเวลา
                                            </label>
                                        </div>
                                    </div>

                                    <!-- Date range -->
                                    <div class="form-group" id="date_range">
                                        <label>Step 4. เลือกช่วงเวลา</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="far fa-calendar-alt"></i>
                                                </span>
                                            </div>
                                            <input type="text" class="form-control float-right" id="reservation" name="date">
                                        </div>

                                        <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                </div>

                                <div class="card-footer">
                                    <button type="submit" class="btn btn-success"></i> Export File</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>



    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->



<script>
    $(function() {

        $("#date_range").hide()
        $("#date_range").fadeOut()
        // loadUserOnline();
        // console.log('loadUserOnline()');
    })

    function loadUserOnline() {
        $.ajax({
            url: 'ajax/getUserOnline.php',
            method: 'POST',
            dataType: 'json',
            success: function(data) {
                console.log(data);
                var pathPic = "";
                var body = "";
                $("#bodyUserOnline").html('');
                if (data.length == 0) {
                    $("#bodyUserOnline").html('<h5>There are no users at this time. </h5');
                }
                $("#userOnlineSpan1").html(data.length);
            }
        }).then(function() {
            setTimeout(loadUserOnline, 10000);
        });
    }

    $("input[type=radio][name=time]").change(function() {
        if (this.value == 'all') {
            $("#date_range").fadeOut()
        } else {
            $("#date_range").fadeIn()
        }
    })
</script>