<?php
header('Content-type:application/json;charset=utf-8');
require_once(__DIR__ . "../../checkSession.php");

if (!defined('SITE_ROOT')) {
    include_once '../../../netthai_configs.php';
    require 'path.php';
}

$poll_name = trim($_POST['poll_name']);
$poll_link = trim($_POST['poll_link']);
$poll_status = $_POST['poll_status'];
$poll_action = trim($_POST['poll_action']);
$poll_id = $_POST['poll_id'];

if (!$poll_name && !$poll_link) {
    echo json_encode([
        'status' => 'error',
        'message' => 'input invalid.'
    ]);
    exit();
} else {
    if($poll_action == 'new'){
        // insert new record to db.
        $insertData = array("at_poll_name" => $poll_name, "at_poll_link" => $poll_link, "at_poll_status" => $poll_status);
        $pdomodel->insert("attach_poll", $insertData);

        if ($pdomodel->rowsChanged >= 1) {
            echo json_encode([
                'status' => 'ok',
                'message' => 'insert link poll successfuly.'
            ]);
            exit();
        } else {
            echo json_encode([
                'status' => 'not_change',
                'message' => 'not have new data.'
            ]);
            exit();
        }
    }else if($poll_action == 'update'){
        $updateData = array("at_poll_name" => $poll_name, "at_poll_link" => $poll_link, "at_poll_status" => $poll_status);
        $pdomodel->where("at_poll_id", $poll_id);
        $pdomodel->update("attach_poll", $updateData);
        if($pdomodel->rowsChanged == 0){
            //not change
            echo json_encode([
                'status' => 'not_change',
                'message' => 'not have new data.'
            ]);
            exit();
        }else{
            //updated 
            echo json_encode([
                'status' => 'ok',
                'message' => 'updated link poll successfuly.'
            ]);
            exit();
        }
    }
}
