<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Surveys extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        // Auth
        $this->load->library('ion_auth');
        
        if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
        {
          redirect('auth/login');
        }
        
        $this->load->model('backend/Surveys_model');
        $this->load->model('backend/Questions_model');
        $this->load->model('backend/Visitors_model');
        $this->load->helper('status');
        $this->form_validation->set_error_delimiters('<div style="font-weight:bold;color:#d9534f;">', '</div>');
    } 

    /*
     * Listing
     */
    function index()
    {
        $data = array();
        $params = array();
        $params['limit'] = RECORDS_PER_PAGE; 
        $params['offset'] = ($this->input->get('per_page')) ? $this->input->get('per_page') : 0;
        $config = $this->config->item('pagination');

        /* --------- Filter -------- */
        if ($this->input->get('keyword')!=""){

            $config['base_url'] = site_url('backend/surveys?keyword='.$this->input->get('keyword'));

        }else{
            $config['base_url'] = site_url('backend/surveys?');
        }
        /* --------- /.Filter -------- */  

        $config['total_rows'] = $this->Surveys_model->list_count();
        $this->pagination->initialize($config);  
        $data['surveyCountAll'] = $this->Surveys_model->count_all();
        $data['surveyCount'] = $config['total_rows'];
        $data['result'] = $this->Surveys_model->list_render($params);
        $data['content'] = 'backend/surveys/list_view';
        $this->load->view('template/backend_template', $data);
    }

    /*
     * Adding a new
     */
    function create()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            // Validation
            $this->form_validation->set_rules('survey_name', 'ชื่อ', 'trim|required');

            if ($this->form_validation->run() == FALSE)
            {
                $data['content'] = 'backend/surveys'; // view
                $this->load->view('template/backend_template', $data); // template
            }
            else
            {
                # survey_datetime
               if (!empty($this->input->post('datetime'))) {
                  $datetime = $this->input->post('datetime');
               }else{
                  $datetime = NULL;
               }
                // Insert
                $params = array(
                    'survey_name' => $this->input->post('survey_name'),
                    'survey_datetime' => $datetime,
                    'survey_platform' => $this->input->post('platform'),
                    'survey_status' => '0'
                );
            
                $survey_id = $this->Surveys_model->create($params);
                $this->session->set_flashdata('message','บันทึกเรียบร้อย');
                $this->session->set_flashdata('message_type','success');
                redirect('backend/surveys','refresh');
            } //.if validation
        }
        else
        {   
            redirect('backend/surveys','refresh');
        } //.if POST
    }  

    /*
     * Editing
     */
    function edit()
    {   

        if(isset($_POST) && count($_POST) > 0)     
        {   
            // Validation
            $this->form_validation->set_rules('survey_name', 'ชื่อประเภทงาน', 'trim|required');

            if ($this->form_validation->run() == FALSE)
            {
                $data['content'] = 'backend/surveys'; // view
                $this->load->view('template/backend_template', $data); // template
            }
            else
            {
               # survey_datetime
               if (!empty($this->input->post('datetime'))) {
                  $datetime = $this->input->post('datetime');
               }else{
                  $datetime = $this->input->post('datetime_org');
               }
                // Edit
                $params = array(
                    'survey_name' => $this->input->post('survey_name'),
                    'survey_datetime' => $datetime,
                    'survey_platform' => $this->input->post('platform')
                );
                $survey_id = decrypt(urldecode($this->input->post('survey_id')));
            
                $this->Surveys_model->edit($survey_id,$params);   
                $this->session->set_flashdata('message', 'แก้ไขเรียบร้อยแล้ว');
                $this->session->set_flashdata('message_type', 'success');
                redirect('backend/surveys','refresh');
            } //.if validation
        }
        else
        {   
            redirect('backend/surveys','refresh');
        } //.if POST
    }

    function show($survey_id = NULL)
    {   

        $survey_id = decrypt(urldecode($survey_id));
        $data['survey'] = $this->Surveys_model->show($survey_id);
        $data['questions'] = $this->Questions_model->list_render($survey_id);
        $data['countvisitor'] = $this->Visitors_model->list_count($survey_id);
        
        if(isset($data['survey']['survey_id']))
        {
            $data['content'] = 'backend/surveys/show_view'; // view
            $this->load->view('template/backend_template', $data); // template
        }
        else
        {
            redirect('backend/surveys','refresh');
        }
    }

    function report($survey_id = NULL)
    {   
        $survey_id = decrypt(urldecode($survey_id));
        $data['survey'] = $this->Surveys_model->show($survey_id);
        $data['questions'] = $this->Questions_model->list_render($survey_id);
        $data['countvisitor'] = $this->Visitors_model->list_count($survey_id);
        $data['comments'] = $this->Visitors_model->list_comment($survey_id);
        
        if(isset($data['survey']['survey_id']))
        {
            $this->load->view('backend/surveys/report_view-chartjs', $data); // template
        }
        else
        {
            redirect('surveys','refresh');
        }
    }

    function remove($survey_id = NULL)
    {

        $survey_id = decrypt(urldecode($survey_id));
        $survey = $this->Surveys_model->show($survey_id);
        $answer_exist = $this->Surveys_model->count_data_exist($survey_id);

        // check if the call exists before trying to delete it
        if(isset($survey['survey_id']))
        {
             $this->Surveys_model->remove($survey_id);
             $this->Surveys_model->remove_visitor($survey_id);
             $this->Surveys_model->remove_question($survey_id);
             $this->session->set_flashdata('message', 'Delete Completed.');
             $this->session->set_flashdata('message_type', 'success');
             redirect('backend/surveys');
        }
        else
        {
            $this->session->set_flashdata('message', 'Not exist.');
            redirect('backend/surveys','refresh');
        }

    }

    function updatestatus($survey_id = NULL)
    {
        $survey_id = decrypt(urldecode($survey_id));
        $survey = $this->Surveys_model->show($survey_id);

        // check if the call exists before trying to delete it
        if(isset($survey['survey_id']))
        {
            if ($survey['survey_status']=="0") {
                $status = '1';
            }else{
                $status = '0';
            }
            // Edit
            $params = array(
                'survey_status' => $status
            );
            // $survey_id = decrypt(urldecode($this->input->post('survey_id')));
        
            $this->Surveys_model->edit($survey_id,$params);   
            $this->session->set_flashdata('message', 'อัพเดทสถานะเรียบร้อยแล้ว');
            $this->session->set_flashdata('message_type', 'success');
            redirect('backend/surveys','refresh');
        }
        else
        {
            $this->session->set_flashdata('message', 'Not exist.');
            redirect('backend/surveys','refresh');
        }

    }

    // create question
    function create_question($survey_id = '')
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $survey_id = decrypt(urldecode($survey_id));
            // Validation
            $this->form_validation->set_rules('question_name', 'ชื่อวีดีโอ', 'trim|required');

            if ($this->form_validation->run() == FALSE)
            {
                $survey_id = urlencode(encrypt($survey_id));
                redirect('backend/surveys/show/'.$survey_id,'refresh');
            }
            else
            {
                // Insert
                $params = array(
                    'question_name' => $this->input->post('question_name'),
                    'survey_id' => $survey_id
                );
                
                # insert action
                $this->Questions_model->create($params);
                $this->session->set_flashdata('message','บันทึกเรียบร้อย');
                $this->session->set_flashdata('message_type','success');
                $survey_id = urlencode(encrypt($survey_id));
                redirect('backend/surveys/show/'.$survey_id,'refresh');
            } //.if validation
        }
        else
        {   
            redirect('backend/surveys/show/'.$survey_id,'refresh');
        } //.if POST
    } 

    function edit_question()
    {   
        // check if the id exists before trying to edit it
        $question_id =  decrypt(urldecode($this->input->post('question_id')));

        $data['question'] = $this->Questions_model->show($question_id);

        if(isset($data['question']['question_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            { 
            // Validation
            $this->form_validation->set_rules('question_name', 'หัวข้อ', 'trim|required');

                if ($this->form_validation->run() == FALSE)
                {
                    $survey_id = urlencode(encrypt($data['question']['survey_id']));
                    $data['content'] = 'backend/surveys/show_view/'.$survey_id; // view
                    $this->load->view('template/backend_template', $data); // template
                }
                else
                {
                    // Edit
                    $params = array(
                    'question_name' => $this->input->post('question_name')
                );
                    
                    # edit action
                    $this->Questions_model->edit($question_id,$params);   
                    $this->session->set_flashdata('message','แก้ไขเรียบร้อย');
                    $this->session->set_flashdata('message_type','success');
                    # redirect
                    $survey_id = urlencode(encrypt($data['question']['survey_id']));
                    redirect('backend/surveys/show/'.$survey_id,'refresh');

                } //.if validation
            }
            else
            {   
                $survey_id = urlencode(encrypt($data['question']['survey_id']));
                redirect('backend/surveys/show/'.$survey_id,'refresh');
                
            } //.if POST
        }else{
            redirect('backend/surveys','refresh');
        }
        
    } 

    function remove_question($question_id = NULL)
    {
        $question_id = decrypt(urldecode($question_id));
        $questions = $this->Questions_model->show($question_id);
        // check if the call exists before trying to delete it
        if(isset($questions['question_id']))
        {
            $answer_exist = $this->Questions_model->count_data_exist($questions['survey_id']);

            # Check Data Exist
            if ($answer_exist > "0") {
                $this->session->set_flashdata('message', 'Cannot Delete.Because Data Exist.');
                $this->session->set_flashdata('message_type', 'error');
                $survey_id = urlencode(encrypt($questions['survey_id']));
                redirect('backend/surveys/show/'.$survey_id,'refresh');
            }else{
                $this->Questions_model->remove($question_id);
                $this->session->set_flashdata('message', 'ลบเรียบร้อยแล้ว');
                $this->session->set_flashdata('message_type', 'success');
                $survey_id = urlencode(encrypt($questions['survey_id']));
                redirect('backend/surveys/show/'.$survey_id,'refresh');
            }
        }
        else
        {
            redirect('backend/surveys','refresh');
        }
    }


    function reset_answer($survey_id = NULL)
    {

        $survey_id = decrypt(urldecode($survey_id));
        $survey = $this->Surveys_model->show($survey_id);
        if(isset($survey['survey_id']))
        {
             $this->Visitors_model->remove($survey_id);
             $this->session->set_flashdata('message', 'Reset Completed.');
             $this->session->set_flashdata('message_type', 'success');
             $survey_id = urlencode(encrypt($survey_id));
             redirect('backend/surveys/show/');
        }
        else
        {
            $this->session->set_flashdata('message', 'Not exist.');
            redirect('backend/surveys','refresh');
        }

    }

    
}