<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Questions_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->form_validation->set_error_delimiters('<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>', '</div>');
    }

    function count_all($survey_id)
    {
        $this->db->where('questions.survey_id', $survey_id);
        $this->db->from('questions');
        return $this->db->count_all_results();
    }

    function count_data_exist($question_id)
    {
        $where  = "`answers`.`question_id` = '$question_id'";
        $this->db->where($where);
        $this->db->from('answers');
        return $this->db->count_all_results();
    }

    function list_count($survey_id)
    {
        /* --------- Filter -------- */
        # keyword
        if ($this->input->get('keyword')!="") {
            $keyword= $this->input->get('keyword');
            $where  = "(`questions`.`question_name` LIKE '%$keyword%')";
            $this->db->where($where);
        }
        /* --------- /.Filter -------- */

        $this->db->where('questions.survey_id', $survey_id);
        $this->db->from('questions');
        return $this->db->count_all_results();
    }

    function list_render($survey_id)
    {
        $this->db->where('questions.survey_id', $survey_id);
        $this->db->order_by('question_id', 'asc');        
        return $this->db->get('questions')->result_array();
    }

    function show($question_id)
    {
        return $this->db->get_where('questions',array('question_id'=>$question_id))->row_array();
    }

    function create($params)
    {
        $this->db->insert('questions',$params);
        return $this->db->insert_id();
    }
    
    function edit($question_id,$params)
    {
        $this->db->where('question_id',$question_id);
        return $this->db->update('questions',$params);
    }
    
    function remove($question_id)
    {
        return $this->db->delete('questions',array('question_id'=>$question_id));
    }


}