<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Surveys_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->form_validation->set_error_delimiters('<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>', '</div>');
    }

    /*
     *  All count
     */
    function count_all()
    {
        $this->db->from('surveys');
        return $this->db->count_all_results();
    }

    function count_data_exist($survey_id)
    {
        $where  = "`visitors`.`survey_id` = '$survey_id'";
        $this->db->where($where);
        $this->db->from('visitors');
        return $this->db->count_all_results();
    }

    /*
     * List count
     */
    function list_count()
    {
        /* --------- Filter -------- */
        # keyword
        if ($this->input->get('keyword')!="") {
            $keyword= $this->input->get('keyword');
            $where  = "(`surveys`.`survey_name` LIKE '%$keyword%')";
            $this->db->where($where);
        }
        /* --------- /.Filter -------- */

        $this->db->where('surveys.survey_status', '1');
        $this->db->from('surveys');
        return $this->db->count_all_results();
    }

    /*
     * List Render
     */
    function list_render($params = array())
    {
        /* --------- Filter -------- */
        # keyword
        if ($this->input->get('keyword')!="") {
            $keyword= $this->input->get('keyword');
            $where  = "(`surveys`.`survey_name` LIKE '%$keyword%')";
            $this->db->where($where);
        }
        /* --------- /.Filter -------- */

        $this->db->order_by('survey_name', 'asc');
        if(isset($params) && !empty($params))
        {
            $this->db->limit($params['limit'], $params['offset']);
        }
        $this->db->where('surveys.survey_status', '1');
        return $this->db->get('surveys')->result_array();
    }

    /*
     * Get Post by survey_id
     */
    function show($survey_id)
    {
        $this->db->where('surveys.survey_status', '1');
        return $this->db->get_where('surveys',array('survey_id'=>$survey_id))->row_array();
    }

}