<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Visitors_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->form_validation->set_error_delimiters('<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>', '</div>');
    }

    function create_visitor($params)
    {
        $this->db->insert('visitors',$params);
        return $this->db->insert_id();
    }

    function count_score($question_id)
    {
        $this->db->where('question_id', $question_id); 
        $this->db->from('visitors');    
        return $this->db->count_all_results();
    }

    function list_count($survey_id)
    {
        $this->db->where('visitors.survey_id', $survey_id);    
        $this->db->from('visitors');    
        return $this->db->count_all_results();
    }

    function list_comment($survey_id)
    {
        $this->db->where('visitors.survey_id', $survey_id); 
        $this->db->where('visitors.visitor_comment<>""'); 
        return $this->db->get('visitors')->result_array();
    }

}