<?php defined('BASEPATH') OR exit('No direct script access allowed');?>
<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">ผู้ใช้งาน</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          	<a href="auth/create_user" class="btn btn-success"><i class="fa fa-plus-square"></i>&nbsp;เพิ่ม</a>  
    		<a href="<?php echo site_url('auth'); ?>" class="btn btn-primary"><i class="fa fa-refresh"></i><span class="hidden-xs">&nbsp;รีเฟรช</span></a>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<section class="content">
<?php
# Action
if($this->session->flashdata('message') != ''){  
	echo '<script>Swal.fire({ position: "center",icon: "'.$this->session->flashdata('message_type').'",title: "'.$this->session->flashdata('message').'",showConfirmButton: false,timer: 1500 })</script>';
}
?>

	<table id="tableuser" class="table table-bordered table-hover">
	<thead>
		<tr>
			<th>สถานะ</th>
			<th>ชื่อ</th>
			<th>นามสกุล</th>
			<th>อีเมล</th>
			<th>กลุ่ม/สิทธิ์</th>
			<th><?php echo lang('index_action_th');?></th>
		</tr>
	</thead>
	<tbody>
		<?php foreach ($users as $user):?>
		<?php $id = $user->id; ?>
		<tr>
			<td><?php echo ($user->active) ? anchor("auth/deactivate/".$id, lang('index_active_link')) : anchor("auth/activate/". $user->id, lang('index_inactive_link'));?></td>
            <td><?php echo htmlspecialchars($user->first_name,ENT_QUOTES,'UTF-8');?></td>
            <td><?php echo htmlspecialchars($user->last_name,ENT_QUOTES,'UTF-8');?></td>
            <td><?php echo htmlspecialchars($user->email,ENT_QUOTES,'UTF-8');?></td>
			<td>
				<?php foreach ($user->groups as $group):?>
					<?php echo anchor("auth/edit_group/".$group->id, htmlspecialchars($group->description,ENT_QUOTES,'UTF-8')) ;?><br />
                <?php endforeach?>
			</td>
			
			<td>
				
				<a href="<?php echo site_url('auth/edit_user/'.$id); ?>"
		            class="btn btn-outline-secondary btn-sm"><span
		                class="fa fa-edit"></span>&nbsp;แก้ไข</a>
			</td>
		</tr>
	<?php endforeach;?>
	</tbody>
</table>
</section>