<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$survey_id = urlencode(encrypt($survey['survey_id']));
?>
<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-8">
        <h4 class="m-0 text-dark"><?php echo $survey['survey_name'];?></h4>
        <strong>Date/Time:</strong>&nbsp;
        <?php
        if ($survey['survey_datetime']!=NULL) {
          echo dateThai($survey['survey_datetime'],"datetime_nosec");
        }else{
          echo '';
        }
        ?>
        <br>
        <strong>Platform:</strong>&nbsp;<?php echo $survey['survey_platform'];?><br>
        <strong>สถานะ:</strong>&nbsp;<?php echo surveyStatus($survey['survey_status']);?><br>
        <strong>จำนวนผู้โหวต:</strong>&nbsp;<?php echo number_format($countvisitor);?>&nbsp;คน<br>
      </div><!-- /.col -->
      <div class="col-sm-4 text-right">
        <a href="<?= base_url('backend/surveys/report/'.$survey_id);?>" class="btn btn-primary btn-sm" target="_blank"><span class="fa fa-bar-chart"></span>&nbsp;ดูผลสำรวจ</a>
           <a href="<?= base_url('surveys/show/'.$survey['survey_id']);?>" class="btn btn-secondary btn-sm" target="_blank"><span class="fa fa-eye"></span>&nbsp;ดูแบบสำรวจ</a>
      </div>
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<section class="content">

<section class="content" style="background: #FFFFFF;">

<?php
if($this->session->flashdata('message') != ''){  
	echo '<script>Swal.fire({ position: "center",icon: "'.$this->session->flashdata('message_type').'",title: "'.$this->session->flashdata('message').'",showConfirmButton: false,timer: 1500 })</script>';
}
?>

<div class="card">
  <div class="card-header bg-secondary">
        <h3 class="card-title"><i class="fa fa-list"></i>&nbsp;ตัวเลือก</h3>
        <div class="card-tools">
            <a class="btn btn-success btn-sm" data-toggle="modal" href='#modal-create'><i class="fa fa-plus"></i>&nbsp;เพิ่มตัวเลือก</a>
        </div>
      </div>
  <div class="card-body">
    <table class="table table-striped table-hover">
    	<thead>
    		<tr>
    			<th style="width: 5%;" class="text-center">No.</th>
    			<th>รายการ</th>
          <th class="text-center">Action</th>
    		</tr>
    	</thead>
    	<tbody>
    		<?php 
    		$i=0;
    		foreach ($questions as $question) { 
    		$i++;
    		?>
    		<tr>
            <td style="width:5%;"><?php echo $i; ?></td>
            <td>
               <?php echo nl2br($question['question_name']);?>
            </td>

            <td class="text-center">

              <a href="#modal-edit" data-toggle="modal"
              data-question_id="<?php echo urlencode(encrypt($question['question_id']));?>" 
              data-question_name="<?php echo $question['question_name']; ?>"
              class="btn btn-outline-dark btn-flat btn-sm modal-edit-dialog"><span class="fa fa-edit"></span>&nbsp;แก้ไข</a>

              <?php $question_id = urlencode(encrypt($question['question_id']));?>
              <a href="<?php echo site_url('backend/surveys/remove_question/'.$question_id); ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('<?php echo sprintf('ท่านต้องการลบ&nbsp;'.word_limiter($question['question_name'],'5').'?'); ?>')"><span class="fa fa-trash"></span>&nbsp;ลบ</a>

            </td>
          </tr>
    		<?php } ?>
    	</tbody>
    </table>
  </div>
</div>

</section>

<!-- Modal Create -->
<div class="modal fade" id="modal-create">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">เพิ่มตัวเลือก</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
          <span class="sr-only">Close</span>
        </button>
        
      </div>
      <?php echo form_open_multipart('backend/surveys/create_question/'.$survey_id); ?>
      <div class="modal-body">
          <div class="form-group">
            <textarea name="question_name" class="form-control" rows="3" required></textarea>
          </div>
      </div><!--/.modal-body-->

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class=
        "fa fa-times-circle"></i>&nbsp;ปิดหน้าต่าง</button>
        <button type="submit" class="btn btn-primary"><i class=
        "fa fa-save"></i>&nbsp;บันทึก</button>
      </div>
      <?php echo form_close();?>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- /.Modal Create -->

<!-- Modal Edit -->
<div class="modal fade" id="modal-edit">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">แก้ไขตัวเลือก</h4>
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
      </div>
      <?php echo form_open_multipart('backend/surveys/edit_question/'); ?>
      <div class="modal-body">
        <input type="hidden" id="question_id" name="question_id" class="form-control">
        <div class="form-group">
          <textarea name="question_name" id="question_name" class="form-control" rows="3" required></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class=
        "fa fa-times-circle"></i>&nbsp;ปิดหน้าต่าง</button>
        <button type="submit" class="btn btn-primary"><i class=
        "fa fa-save"></i>&nbsp;แก้ไข</button>
      </div>
      <?php echo form_close();?>
    </div>
  </div>
</div>
<!-- /.Modal Edit -->

<script src="<?= base_url();?>assets/adminlte3/plugins/jquery/jquery.min.js"></script>
<script type="text/javascript">
$(document).on("click", ".modal-edit-dialog", function () {
     var question_id = $(this).data('question_id');
     var question_name = $(this).data('question_name');
     $(".modal-body #question_id").val(question_id);
     $(".modal-body #question_name").val(question_name);
    $('#modal-edit').modal('show');
});
</script>