<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php echo SITE_NAME;?></title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.2/css/all.css" integrity="sha384-oS3vJWv+0UjzBfQzYUhtDYW+Pj2yciDJxpsK1OYPAYjqT085Qq/1cq5FLXAZQ7Ay" crossorigin="anonymous">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?= base_url();?>assets/adminlte3/dist/css/adminlte.min.css">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css?family=Kanit:400,600" rel="stylesheet">
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
  <script src="<?= base_url('assets/sweetalert2-9.5.3/dist/sweetalert2.min.js');?>"></script>
  <link rel="stylesheet" href="<?= base_url('assets/sweetalert2-9.5.3/dist/sweetalert2.min.css');?>">
  <style type="text/css">
  .swal2-popup {
    font-size: 10px; !important;
  }
  </style>
</head>
<body class="hold-transition sidebar-mini" style="font-family: 'Kanit';">


<section class="content" style="background: #FFFFFF;">

<?php
if($this->session->flashdata('message') != ''){  
  echo '<script>Swal.fire({ position: "center",icon: "'.$this->session->flashdata('message_type').'",title: "'.$this->session->flashdata('message').'",showConfirmButton: false,timer: 1500 })</script>';
}
?>

<div class="container">
<div class="row">
  <div class="col-xs-12 col-sm-12 col-md-10 col-lg-10 mx-auto">

<div class="text-center"><h3 class="text-dark m-4"><?php echo $survey['survey_name'];?></h3></div>

<hr>

<div class="chart">
  <canvas id="barChart" style="height:230px"></canvas>
</div>
<!-- jQuery -->
<script src="<?= base_url();?>assets/adminlte3/plugins/jquery/jquery.min.js"></script>
<!-- ChartJS -->
<script src="<?= base_url();?>assets/adminlte3/plugins/chart.js/Chart.min.js"></script>
<script src="<?= base_url();?>assets/adminlte3/plugins/chart.js/chartjs-plugin-datalabels.js"></script>

<script>

$(function () {
  loadDataJson();
})

function loadDataJson(){
  let endpoint = `http://tkdwebinar.com/poll/surveys/json/<?=$survey['survey_id']; ?>`

  $.get(endpoint, function(data) {

    let js_questions = []
    let js_answers = []
    let js_visitors
    
      // console.log(data);
      $.each(data.questions, function(key, value){
        js_questions.push(value.question_name);
      })
      // answers
      js_answers = data.answers
      // visitors
      js_visitors = data.countvisitor

      $('#numVisitors').html(`${js_visitors} คน`);

      setupChartJs(js_questions, js_answers.map(Number))

  });

    setTimeout(loadDataJson, 10000);
    


}

function setupChartJs(questions, answers){

  console.log(questions);
  console.log(answers);
  var areaChartData = {
      labels  : questions,
      datasets: [
        {
          label               : 'Percent(%)',
          backgroundColor     : 'rgba(60,141,188,0.9)',
          borderColor         : 'rgba(60,141,188,0.8)',
          pointRadius          : false,
          pointColor          : '#3b8bba',
          pointStrokeColor    : 'rgba(60,141,188,1)',
          pointHighlightFill  : '#fff',
          pointHighlightStroke: 'rgba(60,141,188,1)',
          data                : answers
        },
      ]
    }

    //-------------
    //- BAR CHART -
    //-------------
    var barChartCanvas = $('#barChart').get(0).getContext('2d')
    var barChartData = jQuery.extend(true, {}, areaChartData)
    var temp0 = areaChartData.datasets[0]
    barChartData.datasets[0] = temp0

    var barChartOptions = {
      responsive              : true,
      maintainAspectRatio     : false,
      datasetFill             : false,
      legend: {
            display: false
         },
      animation: {
        duration: 0
      },
      plugins: {
        datalabels: {
          formatter: function(value) {
              return value.toFixed(2)+"%";
          },
          display: function(context) {
          return context.dataset.data[context.dataIndex] !== 0; // or >= 1 or ...
         },
          anchor: 'end',
          align: 'center',
          color: 'black'
        }
      }
    }

    var barChart = new Chart(barChartCanvas, {
      type: 'horizontalBar', 
      data: barChartData,
      options: barChartOptions
    })

}





</script>

<div class="text-center p-5">
<strong>จำนวนผู้โหวต:</strong>&nbsp;<span id="numVisitors"></span><br>
</div>
  </div><!--/.col-->
</div><!--/.row-->
</div><!--/.contain-->
</section>

<!-- page script -->
</body>
</html>
