<?php
function isImage($file_img)
{
$IMG_TYPE = array('image/pjpeg', 'image/jpeg', 'image/gif', 'image/png', 'image/x-png');
$file_type = $file_img['type'];
return(in_array($file_type, $IMG_TYPE));
}

function uploadResize($file_img, $save_location, $save_filename, $ww=200, $hh=200)
{
$file_name = $file_img['name'];
$file_type = $file_img['type'];
$tmp_name = $file_img['tmp_name'];
switch($file_type){
case "image/pjpeg" :
case "image/jpeg" :
$images_orig = ImageCreateFromJPEG($tmp_name);
break;
case "image/gif":
$images_orig = ImageCreateFromGIF($tmp_name);
break;
case "image/png":
case "image/x-png":
$images_orig = ImageCreateFromPNG($tmp_name);
break;
case "image/bmp":
$images_orig = ImageCreateFromWBMP($tmp_name);
break;
default:
return(false);
}
$orig_width = ImagesX($images_orig);
$orig_height = ImagesY($images_orig);
if($orig_width > $ww || $orig_height>$hh){
if($orig_width > $orig_height){
$hh = ($ww/$orig_width)*$orig_height;
}else{
$ww = ($hh/$orig_height)*$orig_width;
}
}else{
$hh = $orig_height;
$ww = $orig_width;
}
$images_fin = ImageCreateTrueColor($ww, $hh);
@imagecopyresized($images_fin, $images_orig, 0, 0, 0, 0, $ww, $hh, $orig_width, $orig_height);$ext = end(explode(".", $file_name));
$newfilename = $save_filename.".".$ext;
$save = $save_location.$newfilename;
switch($file_type){
case "image/pjpeg" :
case "image/jpeg" :
case "image/jpg" :
ImageJPEG($images_fin, $save ,100); // image quality = 90
break;
case "image/gif":
ImageGIF($images_fin,$save);
break;
case "image/png":
case "image/x-png":
ImagePNG($images_fin,$save);
break;
case "image/bmp":
imageWBMP($images_fin,$save);
default:
return(false);
}
ImageDestroy($images_orig);
ImageDestroy($images_fin);
return($newfilename);
}

//############################# DATE & TIME ###############################
/*** funcDateThai***/
function funcDateThai($strDate)
{
	$strYear = date("Y",strtotime($strDate))+543;
	$strMonth= date("n",strtotime($strDate));
	$strDay= date("j",strtotime($strDate));
	$strW= date("w",strtotime($strDate));
	$strHour= date("H",strtotime($strDate));
	$strMinute= date("i",strtotime($strDate));
	$strSeconds= date("s",strtotime($strDate));
	$strWCut=array("วันอาทิตย์ที่","วันจันทร์ที่","วันอังคารที่","วันพุธที่","วันพฤหัสบดีที่","วันศุกร์ที่","วันเสาร์ที่");
	$strWThai=$strWCut[$strW];
	$strMonthCut = Array("","มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม");
	$strMonthThai=$strMonthCut[$strMonth];
	return "$strDay $strMonthThai $strYear เวลา $strHour:$strMinute น.";
}

function funcDateThai_day($strDate)
{
	$strYear = date("Y",strtotime($strDate))+543;
	$strMonth= date("n",strtotime($strDate));
	$strDay= date("j",strtotime($strDate));
	$strW= date("w",strtotime($strDate));
	$strHour= date("H",strtotime($strDate));
	$strMinute= date("i",strtotime($strDate));
	$strSeconds= date("s",strtotime($strDate));
	$strWCut=array("วันอาทิตย์ที่","วันจันทร์ที่","วันอังคารที่","วันพุธที่","วันพฤหัสบดีที่","วันศุกร์ที่","วันเสาร์ที่");
	$strWThai=$strWCut[$strW];
	$strMonthCut = Array("","มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม");
	$strMonthThai=$strMonthCut[$strMonth];
	return "$strWThai $strDay $strMonthThai $strYear";
}

function funcDateTimeThaiWithOutTime($strDate)
{
	$strYear = date("Y",strtotime($strDate));
	$strMonth= date("m",strtotime($strDate));
	$strDay= date("d",strtotime($strDate));
	$strW= date("w",strtotime($strDate));
	return "$strDay/$strMonth/$strYear";
}



function DateDiff($strDate1,$strDate2)
{
		return (strtotime($strDate2) - strtotime($strDate1))/  ( 60 * 60 * 24 );  // 1 day = 60*60*24
}


function isValidDate($date, $format = 'H:i:s') {
    $dateObj = DateTime::createFromFormat($format, $date);
    return $dateObj && $dateObj->format($format) == $date;
}



function funcTime($strDate)
{
	if($strDate == '00:00:00') return ' < 1 วินาที';
    $strHour= date("H",strtotime($strDate));
    $strMinute= date("i",strtotime($strDate));
	$strSeconds= date("s",strtotime($strDate));
	if($strHour != '00' )
		$str = "$strHour ชม ";
	if($strMinute != '00')
		$str .= "$strMinute นาที ";
	if($strSeconds != '00')
		$str .= "$strSeconds วินาที";
	
    return $str;
}


// function encryptIt( $q ) {
//     $cryptKey  = 'qJB0rGtIn5UB1xG03efyCp*';
//     $qEncoded      = base64_encode( mcrypt_encrypt( MCRYPT_RIJNDAEL_256, md5( $cryptKey ), $q, MCRYPT_MODE_CBC, md5( md5( $cryptKey ) ) ) );
//     return( $qEncoded );
// }

// function decryptIt( $q ) {
//     $cryptKey  = 'qJB0rGtIn5UB1xG03efyCp*';
//     $qDecoded      = rtrim( mcrypt_decrypt( MCRYPT_RIJNDAEL_256, md5( $cryptKey ), base64_decode( $q ), MCRYPT_MODE_CBC, md5( md5( $cryptKey ) ) ), "\0");
//     return( $qDecoded );
// }

/**
 * Copy a file, or recursively copy a folder and its contents
 * @author      Aidan Lister <aidan@php.net>
 * @version     1.0.1
 * @link        http://aidanlister.com/2004/04/recursively-copying-directories-in-php/
 * @param       string   $source    Source path
 * @param       string   $dest      Destination path
 * @param       int      $permissions New folder creation permissions
 * @return      bool     Returns true on success, false on failure
 */
function xcopy($source, $dest, $permissions = 0755)
{
    // Check for symlinks
    if (is_link($source)) {
        return symlink(readlink($source), $dest);
    }

    // Simple copy for a file
    if (is_file($source)) {
        return copy($source, $dest);
    }

    // Make destination directory
    if (!is_dir($dest)) {
        mkdir($dest, $permissions);
    }

    // Loop through the folder
    $dir = dir($source);
    while (false !== $entry = $dir->read()) {
        // Skip pointers
        if ($entry == '.' || $entry == '..') {
            continue;
        }

        // Deep copy directories
        xcopy("$source/$entry", "$dest/$entry", $permissions);
    }

    // Clean up
    $dir->close();
    return true;
}

function delete_directory($dirname) {
	if (is_dir($dirname))
	  $dir_handle = opendir($dirname);
if (!$dir_handle)
	 return false;
while($file = readdir($dir_handle)) {
	  if ($file != "." && $file != "..") {
		   if (!is_dir($dirname."/".$file))
				unlink($dirname."/".$file);
		   else
				delete_directory($dirname.'/'.$file);
	  }
}
closedir($dir_handle);
rmdir($dirname);
return true;
}

/* 
 * php delete function that deals with directories recursively
 */
function delete_files($target) {
    if(is_dir($target)){
        $files = glob( $target . '*', GLOB_MARK ); //GLOB_MARK adds a slash to directories returned
        
        foreach( $files as $file )
        {
            delete_files( $file );      
        }
      
        rmdir( $target );
    } elseif(is_file($target)) {
        unlink( $target );  
    }
}

?>
