
// Example starter JavaScript for disabling form submissions if there are invalid fields
(function () {
    'use strict';
    window.addEventListener('load', function () {
        // Fetch all the forms we want to apply custom Bootstrap validation styles to
        var forms = document.getElementsByClassName('needs-validation');
        // Loop over them and prevent submission
        var validation = Array.prototype.filter.call(forms, function (form) {
            form.addEventListener('submit', function (event) {
                if (form.checkValidity() === false) {
                    console.log('check form');
                    event.preventDefault();
                    event.stopPropagation();
                } else {
                    event.preventDefault();
                    event.stopPropagation();
                    LoadDialog();
                    
                }
                form.classList.add('was-validated');
            }, false);
        });
    }, false);
})();

function LoadDialog() {
    Swal.fire({
        icon: 'info',
        title: 'Checking',
        allowOutsideClick: false,
        timerProgressBar: true,
        onBeforeOpen: () => {
            Swal.showLoading()
            Login();
        }
    }).then((result) => {
        /* Read more about handling dismissals below */
        if (result.dismiss === Swal.DismissReason.timer) {
            console.log('I was closed by the timer')
        }
    })
}

function Login() {

    let page_name = $('input[name=page_name]').val()
    let redirect = ''
    
    
    var email = $('input[name="email"]').val();
    var noid = $('input[name="noid"]').val();

    $.ajax({
        url: 'authen_v4.php',
        type: 'post',
        //   dataType: 'json',
        //   data: $("#form_login").serialize(),
        data: {
            'action': 'login',
            'email': email
            // 'noid': noid
        },
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function (res) {

            res = JSON.parse(res);
            console.log(res);
        
            if (res.status == "success") {
                // redirect to home page.
                // Swal.close();
                window.location.href = res.video_url;
            } else if (res.status == "user_not_found") {
                // Swal.close();
                Swal.fire({
                    icon: 'warning',
                    title: 'ข้อมูลไม่ถูกต้อง',
                    html: 'ขออภัย ไม่พบข้อมูลนี้ในฐานข้อมูล <br> E-mail ไม่ถูกต้อง <br> กรุณาลงทะเบียนเพื่อเข้ารับชม',
                    showCancelButton: true,
                    cancelButtonText: 'CLOSE',
                    confirmButtonText: 'REGISTER'
                }).then((result) => {
                    if (result.value) {
                        // if(task) redirect = `/${task}/register.php`
                        // else redirect = `register.php`
                        // window.location.href = `${redirect}`
                        window.location.href = 'register.php'
                    }
                });
            } else if(res.status == "user_not_access"){
                Swal.fire({
                    icon: 'warning',
                    title: 'สถานะการชมรออนุมัติ',
                    html: 'สถานะการเข้ารับชมของท่านยังไม่อนุมัติ <br> กรุณารอผู้ดูแลอนุมัติการเข้าชม'
                });
             } else {
                Swal.fire({
                    icon: 'error',
                    title: 'เกิดข้อผิดพลาดในการเชื่อมต่อกับเซิฟเวอร์',
                    text: 'เกิดผิดพลาดบางประการ กรุณาติดต่อผู้ดูแลระบบ'
                })
            }
        },
        error: function () {
            console.log('error');
        }
    }).then(function () {
        // reset form & clear validate  
        $("#form_register")[0].reset();
        $("#form_register").removeClass('was-validated');
    });
}



function isCharKey(evt) {
    var theEvent = evt || window.event;

    // Handle paste
    if (theEvent.type === 'paste') {
        key = event.clipboardData.getData('text/plain');
    } else {
        // Handle key press
        var key = theEvent.keyCode || theEvent.which;
        key = String.fromCharCode(key);
    }
    var regex = /[0-9]|\./;
    if (!regex.test(key)) {
        theEvent.returnValue = false;
        if (theEvent.preventDefault) theEvent.preventDefault();
    }
}
